/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.junit.Test;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.AggregateSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.KeyStoreBackedSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.X500AttributeTypeAndValue;
import org.wildfly.security.x500.X500PrincipalBuilder;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class CustomRealmMapperTest {
    private final String REALM_A = "realmA";
    private final String REALM_B = "realmB";

    @Test
    public void testEvidenceUsedInServerAuthenticationContextRealmMapping() throws Exception {
        CustomRealmMapper mapper = new CustomRealmMapper();
        X509Certificate[] chainedCertificates = CustomRealmMapperTest.populateCertificateChain();
        KeyStoreBackedSecurityRealm authenticationRealm = this.createKeystoreSecurityRealm(chainedCertificates);
        FileSystemSecurityRealm authorizationRealm = this.createSecurityRealm(true, "realmA");
        AggregateSecurityRealm realm = new AggregateSecurityRealm((SecurityRealm)authenticationRealm, (SecurityRealm)authorizationRealm);
        FileSystemSecurityRealm wrongRealm = this.createSecurityRealm(false, "realmB");
        X500AttributePrincipalDecoder cnDecoder = new X500AttributePrincipalDecoder("2.5.4.3");
        RegexNameRewriter cnValueRegex = new RegexNameRewriter(Pattern.compile(".*([0-9]+)$"), "$1", true);
        SecurityDomain securityDomain = SecurityDomain.builder().addRealm("realmA", (SecurityRealm)realm).build().addRealm("realmB", (SecurityRealm)wrongRealm).build().setDefaultRealmName("realmB").setPermissionMapper((permissionMappable, roles) -> roles.contains("Admin") ? LoginPermission.getInstance() : PermissionVerifier.NONE).setRealmMapper((RealmMapper)mapper).setPrincipalDecoder((PrincipalDecoder)cnDecoder).setPreRealmRewriter(NameRewriter.chain((NameRewriter[])new NameRewriter[]{cnValueRegex})).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(chainedCertificates);
        Assert.assertTrue((boolean)sac.verifyEvidence((Evidence)evidence));
        Assert.assertTrue((boolean)sac.authorize());
    }

    private KeyStoreBackedSecurityRealm createKeystoreSecurityRealm(X509Certificate[] chainedCertificates) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        for (int i = 0; i < chainedCertificates.length; ++i) {
            keyStore.setCertificateEntry(String.valueOf(i), chainedCertificates[i]);
        }
        return new KeyStoreBackedSecurityRealm(keyStore);
    }

    private FileSystemSecurityRealm createSecurityRealm(boolean isAdmin, String realmName) throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(this.getRootPath(true, realmName));
        if (isAdmin) {
            this.addUser((ModifiableSecurityRealm)realm, "0", "Admin");
        } else {
            this.addUser((ModifiableSecurityRealm)realm, "0", "Employee");
        }
        return realm;
    }

    private Path getRootPath(boolean deleteIfExists, String realmName) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm/" + realmName);
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void addUser(ModifiableSecurityRealm realm, String userName, String roles) throws RealmUnavailableException {
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        ModifiableRealmIdentity realmIdentity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userName));
        realmIdentity.create();
        realmIdentity.setAttributes((Attributes)attributes);
        realmIdentity.dispose();
    }

    private static X509Certificate[] populateCertificateChain() throws Exception {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        KeyPair[] keyPairs = new KeyPair[5];
        for (int i = 0; i < keyPairs.length; ++i) {
            keyPairs[i] = keyPairGenerator.generateKeyPair();
        }
        X509Certificate[] orderedCertificates = new X509Certificate[5];
        for (int i = 0; i < orderedCertificates.length; ++i) {
            X509CertificateBuilder builder = new X509CertificateBuilder();
            X500PrincipalBuilder principalBuilder = new X500PrincipalBuilder();
            principalBuilder.addItem(X500AttributeTypeAndValue.create((String)"2.5.4.3", (ASN1Encodable)ASN1Encodable.ofUtf8String((String)("bob" + i))));
            X500Principal dn = principalBuilder.build();
            builder.setSubjectDn(dn);
            if (i == orderedCertificates.length - 1) {
                builder.setIssuerDn(dn);
                builder.setSigningKey(keyPairs[i].getPrivate());
            } else {
                principalBuilder = new X500PrincipalBuilder();
                principalBuilder.addItem(X500AttributeTypeAndValue.create((String)"2.5.4.3", (ASN1Encodable)ASN1Encodable.ofUtf8String((String)("bob" + (i + 1)))));
                X500Principal issuerDn = principalBuilder.build();
                builder.setIssuerDn(issuerDn);
                builder.setSigningKey(keyPairs[i + 1].getPrivate());
                builder.addExtension((X509CertificateExtension)new SubjectAlternativeNamesExtension(true, Arrays.asList(new GeneralName.RFC822Name("bob" + i + "@example.com"), new GeneralName.DNSName("bob" + i + ".example.com"), new GeneralName.RFC822Name("bob" + i + "@anotherexample.com"))));
            }
            builder.setSignatureAlgorithmName("SHA256withRSA");
            builder.setPublicKey(keyPairs[i].getPublic());
            orderedCertificates[i] = builder.build();
        }
        return orderedCertificates;
    }

    private class CustomRealmMapper
    implements RealmMapper {
        public String getRealmMapping(Principal principal, Evidence evidence) {
            return evidence != null ? "realmA" : "realmB";
        }
    }
}

