/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.security.Permission;
import java.util.Arrays;
import org.junit.Assert;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.ldap.LdapTestSuite;
import org.wildfly.security.permission.PermissionVerifier;

public abstract class AbstractAttributeMappingSuiteChild {
    protected void assertAttributeValue(Attributes.Entry values, String ... expectedValues) {
        Assert.assertNotNull((String)"Attribute values are null.", (Object)values);
        Assert.assertEquals((String)"Different number of attributes values", (long)expectedValues.length, (long)values.size());
        for (String expectedValue : expectedValues) {
            Assert.assertTrue((String)("Value [" + expectedValue + "] for attribute [" + values.getKey() + "] not found in " + Arrays.toString(values.toArray())), (boolean)values.contains((Object)expectedValue));
        }
        for (Object value : values.toArray()) {
            Assert.assertTrue((String)("Value [" + String.valueOf(value) + "] for attribute [" + values.getKey() + "] was not expected"), (boolean)Arrays.asList(expectedValues).contains(value));
        }
    }

    protected void assertAttributes(AssertResultHandler handler, AttributeMapping ... expectedAttributes) throws RealmUnavailableException {
        this.assertAttributes("plainUser", handler, expectedAttributes);
    }

    protected void assertAttributes(String principalName, AssertResultHandler handler, AttributeMapping ... expectedAttributes) throws RealmUnavailableException {
        SecurityDomain.Builder builder = SecurityDomain.builder();
        builder.setDefaultRealmName("default").addRealm("default", (SecurityRealm)LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").searchRecursive().setRdnIdentifier("uid").map(expectedAttributes).build().build()).build();
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        SecurityDomain securityDomain = builder.build();
        this.assertAttributes(securityDomain, principalName, handler);
    }

    protected void assertAttributes(SecurityDomain securityDomain, String principalName, AssertResultHandler handler) throws RealmUnavailableException {
        ServerAuthenticationContext serverAuthenticationContext = securityDomain.createNewAuthenticationContext();
        serverAuthenticationContext.setAuthenticationName(principalName);
        Assert.assertTrue((String)("Principal [" + principalName + "] does not exist."), (boolean)serverAuthenticationContext.exists());
        Assert.assertTrue((String)"Authorization failed", (boolean)serverAuthenticationContext.authorize(principalName));
        SecurityIdentity securityIdentity = serverAuthenticationContext.getAuthorizedIdentity();
        Attributes attributes = securityIdentity.getAttributes();
        Assert.assertFalse((String)("No attributes found for principal [" + principalName + "]."), (boolean)attributes.isEmpty());
        handler.assertAttributes(attributes);
    }

    protected static interface AssertResultHandler {
        public void assertAttributes(Attributes var1);
    }
}

