/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.form;

import java.net.URI;
import java.util.HashMap;
import mockit.integration.junit4.JMockit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

@RunWith(value=JMockit.class)
public class FormAuthenticationMechanismTest
extends AbstractBaseHttpTest {
    @Test
    public void testFormWithoutErrorPage() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(HttpConstants.CONFIG_REALM, "Realm");
        properties.put(HttpConstants.CONFIG_CONTEXT_PATH, "/application");
        properties.put(HttpConstants.CONFIG_LOGIN_PAGE, "/login.jsp");
        HttpServerAuthenticationMechanism mechanism = this.formFactory.createAuthenticationMechanism("FORM", properties, this.getCallbackHandler("username", "Realm", "password"));
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest("POST", new String[]{"", "password"}, new URI("http://localhost:8080/application/j_security_check"));
        mechanism.evaluateRequest((HttpServerRequest)request);
        AbstractBaseHttpTest.TestingHttpServerResponse response = request.getResponse();
        Assert.assertEquals((long)response.getStatusCode(), (long)302L);
        Assert.assertEquals((Object)"http://localhost:8080/application", (Object)response.getLocation());
    }

    @Test
    public void testFormWithErrorPage() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(HttpConstants.CONFIG_REALM, "Realm");
        properties.put(HttpConstants.CONFIG_CONTEXT_PATH, "/application");
        properties.put(HttpConstants.CONFIG_LOGIN_PAGE, "/login.jsp");
        properties.put(HttpConstants.CONFIG_ERROR_PAGE, "/error.jsp");
        HttpServerAuthenticationMechanism mechanism = this.formFactory.createAuthenticationMechanism("FORM", properties, this.getCallbackHandler("username", "Realm", "password"));
        AbstractBaseHttpTest.TestingHttpServerRequest request = new AbstractBaseHttpTest.TestingHttpServerRequest("POST", new String[]{"", "password"}, new URI("http://localhost:8080/application/j_security_check"));
        mechanism.evaluateRequest((HttpServerRequest)request);
        AbstractBaseHttpTest.TestingHttpServerResponse response = request.getResponse();
        Assert.assertEquals((long)response.getStatusCode(), (long)302L);
        Assert.assertEquals((Object)"http://localhost:8080/application/error.jsp", (Object)response.getLocation());
    }
}

