/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.credential.Credential;

public final class MechanismConfiguration {
    private final Function<Principal, Principal> preRealmRewriter;
    private final Function<Principal, Principal> postRealmRewriter;
    private final Function<Principal, Principal> finalRewriter;
    private final RealmMapper realmMapper;
    private final Map<String, MechanismRealmConfiguration> mechanismRealms;
    private final SecurityFactory<Credential> serverCredentialFactory;
    public static final MechanismConfiguration EMPTY = new MechanismConfiguration(Function.identity(), Function.identity(), Function.identity(), null, Collections.emptyList(), null);

    MechanismConfiguration(Function<Principal, Principal> preRealmRewriter, Function<Principal, Principal> postRealmRewriter, Function<Principal, Principal> finalRewriter, RealmMapper realmMapper, Collection<MechanismRealmConfiguration> mechanismRealms, SecurityFactory<Credential> serverCredentialFactory) {
        Assert.checkNotNullParam("mechanismRealms", mechanismRealms);
        this.preRealmRewriter = preRealmRewriter;
        this.postRealmRewriter = postRealmRewriter;
        this.finalRewriter = finalRewriter;
        this.realmMapper = realmMapper;
        Iterator<MechanismRealmConfiguration> iterator = mechanismRealms.iterator();
        if (!iterator.hasNext()) {
            this.mechanismRealms = Collections.emptyMap();
        } else {
            MechanismRealmConfiguration item = iterator.next();
            if (!iterator.hasNext()) {
                this.mechanismRealms = Collections.singletonMap(item.getRealmName(), item);
            } else {
                LinkedHashMap<String, MechanismRealmConfiguration> map = new LinkedHashMap<String, MechanismRealmConfiguration>(mechanismRealms.size());
                map.put(item.getRealmName(), item);
                do {
                    item = iterator.next();
                    map.put(item.getRealmName(), item);
                } while (iterator.hasNext());
                this.mechanismRealms = Collections.unmodifiableMap(map);
            }
        }
        this.serverCredentialFactory = serverCredentialFactory;
    }

    public Function<Principal, Principal> getPreRealmRewriter() {
        return this.preRealmRewriter;
    }

    public Function<Principal, Principal> getPostRealmRewriter() {
        return this.postRealmRewriter;
    }

    public Function<Principal, Principal> getFinalRewriter() {
        return this.finalRewriter;
    }

    public RealmMapper getRealmMapper() {
        return this.realmMapper;
    }

    public Collection<String> getMechanismRealmNames() {
        return this.mechanismRealms.keySet();
    }

    public SecurityFactory<Credential> getServerCredentialFactory() {
        return this.serverCredentialFactory;
    }

    public MechanismRealmConfiguration getMechanismRealmConfiguration(String realmName) {
        return this.mechanismRealms.get(realmName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final MechanismRealmConfiguration[] NO_REALM_CONFIGS = new MechanismRealmConfiguration[0];
        private Function<Principal, Principal> preRealmRewriter = Function.identity();
        private Function<Principal, Principal> postRealmRewriter = Function.identity();
        private Function<Principal, Principal> finalRewriter = Function.identity();
        private RealmMapper realmMapper;
        private List<MechanismRealmConfiguration> mechanismRealms;
        private SecurityFactory<Credential> serverCredentialFactory;

        Builder() {
        }

        public Builder setPreRealmRewriter(Function<Principal, Principal> preRealmRewriter) {
            Assert.checkNotNullParam("preRealmRewriter", preRealmRewriter);
            this.preRealmRewriter = preRealmRewriter;
            return this;
        }

        public Builder setPostRealmRewriter(Function<Principal, Principal> postRealmRewriter) {
            Assert.checkNotNullParam("postRealmRewriter", postRealmRewriter);
            this.postRealmRewriter = postRealmRewriter;
            return this;
        }

        public Builder setFinalRewriter(Function<Principal, Principal> finalRewriter) {
            Assert.checkNotNullParam("finalRewriter", finalRewriter);
            this.finalRewriter = finalRewriter;
            return this;
        }

        public Builder setRealmMapper(RealmMapper realmMapper) {
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder addMechanismRealm(MechanismRealmConfiguration configuration) {
            Assert.checkNotNullParam("configuration", configuration);
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            if (mechanismRealms == null) {
                mechanismRealms = this.mechanismRealms = new ArrayList<MechanismRealmConfiguration>(1);
            }
            mechanismRealms.add(configuration);
            return this;
        }

        public Builder setServerCredential(Credential credential) {
            Assert.checkNotNullParam("credential", credential);
            this.serverCredentialFactory = new FixedSecurityFactory<Credential>(credential);
            return this;
        }

        public Builder setServerCredential(SecurityFactory<Credential> credentialFactory) {
            Assert.checkNotNullParam("credential", credentialFactory);
            this.serverCredentialFactory = credentialFactory;
            return this;
        }

        public MechanismConfiguration build() {
            List<MechanismRealmConfiguration> mechanismRealms = this.mechanismRealms;
            mechanismRealms = mechanismRealms == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(mechanismRealms.toArray(NO_REALM_CONFIGS)));
            return new MechanismConfiguration(this.preRealmRewriter, this.postRealmRewriter, this.finalRewriter, this.realmMapper, mechanismRealms, this.serverCredentialFactory);
        }
    }
}

