/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLConfigurator;

final class SSLConfiguratorImpl
implements SSLConfigurator {
    private final ProtocolSelector protocolSelector;
    private final CipherSuiteSelector cipherSuiteSelector;
    private final boolean wantClientAuth;
    private final boolean needClientAuth;
    private final boolean useCipherSuitesOrder;
    private final boolean clientMode;

    SSLConfiguratorImpl(ProtocolSelector protocolSelector, CipherSuiteSelector cipherSuiteSelector, boolean wantClientAuth, boolean needClientAuth, boolean useCipherSuitesOrder) {
        this.protocolSelector = protocolSelector;
        this.cipherSuiteSelector = cipherSuiteSelector;
        this.useCipherSuitesOrder = useCipherSuitesOrder;
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = needClientAuth;
        this.clientMode = false;
    }

    SSLConfiguratorImpl(ProtocolSelector protocolSelector, CipherSuiteSelector cipherSuiteSelector, boolean useCipherSuitesOrder) {
        this.protocolSelector = protocolSelector;
        this.cipherSuiteSelector = cipherSuiteSelector;
        this.useCipherSuitesOrder = useCipherSuitesOrder;
        this.wantClientAuth = false;
        this.needClientAuth = false;
        this.clientMode = true;
    }

    void configure(SSLParameters params, String[] supportedProtocols, String[] supportedCipherSuites) {
        Assert.checkNotNullParam("supportedProtocols", supportedProtocols);
        Assert.checkNotNullParam("supportedCipherSuites", supportedCipherSuites);
        params.setProtocols(this.protocolSelector.evaluate(supportedProtocols));
        params.setCipherSuites(this.cipherSuiteSelector.evaluate(supportedCipherSuites));
        params.setUseCipherSuitesOrder(this.useCipherSuitesOrder);
        params.setWantClientAuth(this.wantClientAuth);
        if (this.needClientAuth) {
            params.setNeedClientAuth(this.needClientAuth);
        }
    }

    @Override
    public void configure(SSLContext context, SSLServerSocket sslServerSocket) {
        sslServerSocket.setUseClientMode(this.clientMode);
        SSLParameters sslParameters = sslServerSocket.getSSLParameters();
        this.configure(sslParameters, sslServerSocket.getSupportedProtocols(), sslServerSocket.getSupportedCipherSuites());
        sslServerSocket.setSSLParameters(sslParameters);
    }

    @Override
    public void configure(SSLContext context, SSLSocket sslSocket) {
        sslSocket.setUseClientMode(this.clientMode);
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        this.configure(sslParameters, sslSocket.getSupportedProtocols(), sslSocket.getSupportedCipherSuites());
        sslSocket.setSSLParameters(sslParameters);
    }

    @Override
    public void configure(SSLContext context, SSLEngine sslEngine) {
        sslEngine.setUseClientMode(this.clientMode);
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        this.configure(sslParameters, sslEngine.getSupportedProtocols(), sslEngine.getSupportedCipherSuites());
        sslEngine.setSSLParameters(sslParameters);
    }

    @Override
    public SSLParameters getDefaultSSLParameters(SSLContext sslContext, SSLParameters original) {
        SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
        this.configure(original, supportedSSLParameters.getProtocols(), supportedSSLParameters.getCipherSuites());
        return original;
    }

    @Override
    public SSLParameters getSupportedSSLParameters(SSLContext sslContext, SSLParameters original) {
        return this.getDefaultSSLParameters(sslContext, original);
    }

    @Override
    public void setWantClientAuth(SSLContext context, SSLSocket sslSocket, boolean value) {
    }

    @Override
    public void setWantClientAuth(SSLContext context, SSLEngine sslEngine, boolean value) {
    }

    @Override
    public void setWantClientAuth(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean value) {
    }

    @Override
    public void setNeedClientAuth(SSLContext context, SSLSocket sslSocket, boolean value) {
    }

    @Override
    public void setNeedClientAuth(SSLContext context, SSLEngine sslEngine, boolean value) {
    }

    @Override
    public void setNeedClientAuth(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean value) {
    }

    @Override
    public void setEnabledCipherSuites(SSLContext sslContext, SSLSocket sslSocket, String[] cipherSuites) {
    }

    @Override
    public void setEnabledCipherSuites(SSLContext sslContext, SSLEngine sslEngine, String[] cipherSuites) {
    }

    @Override
    public void setEnabledCipherSuites(SSLContext sslContext, SSLServerSocket sslServerSocket, String[] suites) {
    }

    @Override
    public void setEnabledProtocols(SSLContext sslContext, SSLSocket sslSocket, String[] protocols) {
    }

    @Override
    public void setEnabledProtocols(SSLContext sslContext, SSLEngine sslEngine, String[] protocols) {
    }

    @Override
    public void setEnabledProtocols(SSLContext sslContext, SSLServerSocket sslServerSocket, String[] protocols) {
    }

    private SSLParameters redefine(SSLParameters original, String[] supportedCipherSuites, String[] supportedProtocols) {
        SSLParameters params = new SSLParameters();
        this.configure(params, this.protocolSelector.evaluate(supportedProtocols), this.cipherSuiteSelector.evaluate(supportedCipherSuites));
        params.setServerNames(original.getServerNames());
        params.setSNIMatchers(original.getSNIMatchers());
        params.setAlgorithmConstraints(original.getAlgorithmConstraints());
        params.setEndpointIdentificationAlgorithm(original.getEndpointIdentificationAlgorithm());
        return params;
    }

    @Override
    public void setSSLParameters(SSLContext sslContext, SSLSocket sslSocket, SSLParameters parameters) {
        sslSocket.setSSLParameters(this.redefine(parameters, sslSocket.getSupportedCipherSuites(), sslSocket.getSupportedProtocols()));
    }

    @Override
    public void setSSLParameters(SSLContext sslContext, SSLEngine sslEngine, SSLParameters parameters) {
        sslEngine.setSSLParameters(this.redefine(parameters, sslEngine.getSupportedCipherSuites(), sslEngine.getSupportedProtocols()));
    }

    @Override
    public void setSSLParameters(SSLContext sslContext, SSLServerSocket sslServerSocket, SSLParameters parameters) {
        sslServerSocket.setSSLParameters(this.redefine(parameters, sslServerSocket.getSupportedCipherSuites(), sslServerSocket.getSupportedProtocols()));
    }

    @Override
    public void setUseClientMode(SSLContext sslContext, SSLSocket sslSocket, boolean mode) {
        if (mode != this.clientMode) {
            throw ElytronMessages.log.invalidClientMode(this.clientMode, mode);
        }
    }

    @Override
    public void setUseClientMode(SSLContext sslContext, SSLEngine sslEngine, boolean mode) {
        if (mode != this.clientMode) {
            throw ElytronMessages.log.invalidClientMode(this.clientMode, mode);
        }
    }

    @Override
    public void setUseClientMode(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean mode) {
        if (mode != this.clientMode) {
            throw ElytronMessages.log.invalidClientMode(this.clientMode, mode);
        }
    }
}

