/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.principal;

import java.io.Serializable;
import java.security.Principal;

public final class NumericPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 6679865697029801196L;
    private final long id;

    public NumericPrincipal(long id) {
        this.id = id;
    }

    public NumericPrincipal(String id) throws NumberFormatException {
        this(Long.parseUnsignedLong(id));
    }

    public long getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NumericPrincipal && this.equals((NumericPrincipal)obj);
    }

    public boolean equals(NumericPrincipal obj) {
        return obj != null && this.id == obj.id;
    }

    @Override
    public int hashCode() {
        return (int)this.id;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return Long.toUnsignedString(this.id);
    }
}

