package org.wildfly.security.x500._private;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.asn1.ASN1Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-09-23T17:51:10-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unexpectedTrailingGarbageInX500principal$str() {
        return "ELY00006: Unexpected trailing garbage in X.500 principal";
    }
    @Override
    public final IllegalArgumentException unexpectedTrailingGarbageInX500principal() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedTrailingGarbageInX500principal$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String nonX509CertificateInCertificateArray$str() {
        return "ELY10025: Non-X.509 certificate found in certificate array";
    }
    @Override
    public final IllegalArgumentException nonX509CertificateInCertificateArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nonX509CertificateInCertificateArray$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String startingPublicKeyNotFoundInCertificateArray$str() {
        return "ELY10026: Starting public key not found in certificate array";
    }
    @Override
    public final IllegalArgumentException startingPublicKeyNotFoundInCertificateArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), startingPublicKeyNotFoundInCertificateArray$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompleteCertificateArray$str() {
        return "ELY10027: Incomplete certificate array";
    }
    @Override
    public final IllegalArgumentException incompleteCertificateArray() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), incompleteCertificateArray$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateCertificateChainFromCertificateMap$str() {
        return "ELY10028: Unable to create X.509 certificate chain from map of certificates";
    }
    @Override
    public final IllegalArgumentException unableToCreateCertificateChainFromCertificateMap() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToCreateCertificateChainFromCertificateMap$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidValueForTrustedAuthorityType$str() {
        return "ELY05110: Invalid value for trusted authority type; expected a value between 0 and 4 (inclusive)";
    }
    @Override
    public final IllegalArgumentException invalidValueForTrustedAuthorityType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValueForTrustedAuthorityType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidValueForGeneralNameType$str() {
        return "ELY05111: Invalid value for a general name type; expected a value between 0 and 8 (inclusive)";
    }
    @Override
    public final IllegalArgumentException invalidValueForGeneralNameType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValueForGeneralNameType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnInvalidGeneralNameForUriType$str() {
        return "ELY07006: Invalid general name for URI type";
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameForUriType(final Throwable cause) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnInvalidGeneralNameForUriType$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnInvalidGeneralNameForIpAddressType$str() {
        return "ELY07007: Invalid general name for IP address type";
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameForIpAddressType() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnInvalidGeneralNameForIpAddressType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnIpAddressGeneralNameCannotBeResolved$str() {
        return "ELY07008: IP address general name cannot be resolved";
    }
    @Override
    public final ASN1Exception asnIpAddressGeneralNameCannotBeResolved(final Throwable cause) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnIpAddressGeneralNameCannotBeResolved$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnInvalidGeneralNameForUriTypeMissingScheme$str() {
        return "ELY07025: Invalid general name for URI type: missing scheme";
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameForUriTypeMissingScheme() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnInvalidGeneralNameForUriTypeMissingScheme$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
