/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wildfly.security.password.interfaces;

import org.wildfly.security.password.OneWayPassword;

/**
 * @author <a href="mailto:fjuma@redhat.com">Farah Juma</a>
 */
public interface SunUnixMD5CryptPassword extends OneWayPassword {

    String ALGORITHM_SUN_CRYPT_MD5 = "sun-crypt-md5";
    String ALGORITHM_SUN_CRYPT_MD5_BARE_SALT = "sun-crypt-md5-bare-salt";

    int DEFAULT_SALT_SIZE = 8;

    int DEFAULT_ITERATION_COUNT = 5500;

    byte[] getSalt();

    byte[] getHash();

    int getIterationCount();
}
