/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.wildfly.security.auth.AuthenticationConfiguration;
import org.wildfly.security.auth.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.principal.AnonymousPrincipal;

class SetAnonymousAuthenticationConfiguration
extends AuthenticationConfiguration {
    private static final Set<String> ONLY_ANONYMOUS = Collections.singleton("ANONYMOUS");

    SetAnonymousAuthenticationConfiguration(AuthenticationConfiguration parent) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetNamePrincipalAuthenticationConfiguration.class));
    }

    @Override
    void filterSaslMechanisms(Collection<String> names) {
        names.retainAll(ONLY_ANONYMOUS);
        super.filterSaslMechanisms(names);
    }

    @Override
    Principal getPrincipal() {
        return AnonymousPrincipal.getInstance();
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetAnonymousAuthenticationConfiguration(newParent);
    }
}

