/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.spi.AuthenticatedRealmIdentity;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.SecurityRealm;
import org.wildfly.security.auth.util.NameRewriter;
import org.wildfly.security.password.Password;

class LdapSecurityRealm
implements SecurityRealm {
    private final DirContextFactory dirContextFactory;
    private final List<NameRewriter> nameRewriters;
    private final PrincipalMapping principalMapping;
    private final Collection<CredentialLoader> credentialLoaders;

    LdapSecurityRealm(DirContextFactory dirContextFactory, List<NameRewriter> nameRewriters, PrincipalMapping principalMapping, Collection<CredentialLoader> credentialLoaders) {
        this.dirContextFactory = dirContextFactory;
        this.nameRewriters = nameRewriters;
        this.principalMapping = principalMapping;
        this.credentialLoaders = credentialLoaders;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) {
        for (NameRewriter current : this.nameRewriters) {
            name = current.rewriteName(name);
        }
        return this.principalMapping.nameIsDn ? new LdapRealmIdentity(null, name) : new LdapRealmIdentity(name, null);
    }

    @Override
    public RealmIdentity createRealmIdentity(Principal principal) {
        if (principal instanceof NamePrincipal || principal instanceof X500Principal) {
            return new LdapRealmIdentity(principal);
        }
        return null;
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) {
        CredentialSupport response = CredentialSupport.UNSUPPORTED;
        if (!Password.class.isAssignableFrom(credentialType)) {
            return response;
        }
        for (CredentialLoader current : this.credentialLoaders) {
            CredentialSupport support = current.getCredentialSupport(this.dirContextFactory, credentialType);
            if (support.isDefinitelyObtainable()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamePair loadNamePair(String simpleName, String distinguishedName) throws NamingException {
        NamePair namePair;
        DirContext context;
        block21: {
            context = null;
            NamingEnumeration<SearchResult> searchResult = null;
            try {
                if (this.principalMapping.nameIsDn) {
                    if (!this.principalMapping.principalUseDn || this.principalMapping.principalUseDn && (this.principalMapping.reloadPrincipalName || this.principalMapping.validatePresence)) {
                        Attribute dnAttribute;
                        Attribute nameAttribute;
                        context = this.dirContextFactory.obtainDirContext(null);
                        ArrayList<String> requiredAttributes = new ArrayList<String>(2);
                        if (this.principalMapping.reloadPrincipalName) {
                            requiredAttributes.add(this.principalMapping.dnAttribute);
                        }
                        if (this.principalMapping.nameAttribute != null) {
                            requiredAttributes.add(this.principalMapping.nameAttribute);
                        }
                        Attributes attributes = context.getAttributes(distinguishedName, requiredAttributes.toArray(new String[requiredAttributes.size()]));
                        if (this.principalMapping.nameAttribute != null && (nameAttribute = attributes.get(this.principalMapping.nameAttribute)) != null) {
                            simpleName = (String)nameAttribute.get();
                        }
                        if (this.principalMapping.reloadPrincipalName && (dnAttribute = attributes.get(this.principalMapping.dnAttribute)) != null) {
                            distinguishedName = (String)dnAttribute.get();
                        }
                    }
                } else {
                    SearchControls searchControls = new SearchControls();
                    searchControls.setSearchScope(this.principalMapping.recursive ? 2 : 1);
                    searchControls.setTimeLimit(10000);
                    context = this.dirContextFactory.obtainDirContext(null);
                    ArrayList<String> requiredAttributes = new ArrayList<String>(2);
                    if (this.principalMapping.reloadPrincipalName) {
                        requiredAttributes.add(this.principalMapping.nameAttribute);
                    }
                    if (this.principalMapping.dnAttribute != null) {
                        requiredAttributes.add(this.principalMapping.dnAttribute);
                    }
                    if (requiredAttributes.size() > 0) {
                        searchControls.setReturningAttributes(requiredAttributes.toArray(new String[requiredAttributes.size()]));
                    }
                    Object[] filterArg = new Object[]{simpleName};
                    String filter = String.format("(%s={0})", this.principalMapping.nameAttribute);
                    searchResult = context.search(this.principalMapping.searchDn, filter, filterArg, searchControls);
                    if (searchResult.hasMore()) {
                        Attribute nameAttribute;
                        Attribute dn;
                        SearchResult result = searchResult.next();
                        if (searchResult.hasMore()) {
                            throw new NamingException("Search returned too many results.");
                        }
                        Attributes attributes = result.getAttributes();
                        if (this.principalMapping.dnAttribute != null && (dn = attributes.get(this.principalMapping.dnAttribute)) != null) {
                            distinguishedName = (String)dn.get();
                        }
                        if (distinguishedName == null) {
                            distinguishedName = result.getName() + ("".equals(this.principalMapping.searchDn) ? "" : "," + this.principalMapping.searchDn);
                        }
                        if (this.principalMapping.reloadPrincipalName && (nameAttribute = attributes.get(this.principalMapping.nameAttribute)) != null) {
                            simpleName = (String)nameAttribute.get();
                        }
                    } else {
                        throw new NamingException("Search returned no results.");
                    }
                }
                namePair = new NamePair(simpleName, distinguishedName);
                if (searchResult == null) break block21;
            }
            catch (Throwable throwable) {
                if (searchResult != null) {
                    searchResult.close();
                }
                if (context != null) {
                    this.dirContextFactory.returnContext(context);
                }
                throw throwable;
            }
            searchResult.close();
        }
        if (context != null) {
            this.dirContextFactory.returnContext(context);
        }
        return namePair;
    }

    private class NamePair {
        private final String simpleName;
        private final String distinguishedName;

        public NamePair(String simpleName, String distinguishedName) {
            this.simpleName = simpleName;
            this.distinguishedName = distinguishedName;
        }
    }

    static class PrincipalMapping {
        private final String searchDn;
        private final boolean recursive;
        private final boolean nameIsDn;
        private final boolean principalUseDn;
        private final String nameAttribute;
        private final String dnAttribute;
        private final boolean validatePresence;
        private final boolean reloadPrincipalName;

        public PrincipalMapping(String searchDn, boolean recursive, boolean nameIsDn, boolean principalUseDn, String nameAttribute, String dnAttribute, boolean validatePresence, boolean reloadPrincipalName) {
            this.searchDn = searchDn;
            this.recursive = recursive;
            this.nameIsDn = nameIsDn;
            this.principalUseDn = principalUseDn;
            this.nameAttribute = nameAttribute;
            this.dnAttribute = dnAttribute;
            this.validatePresence = validatePresence;
            this.reloadPrincipalName = reloadPrincipalName;
        }
    }

    private class LdapRealmIdentity
    implements RealmIdentity {
        private boolean loadedNames = false;
        private String simpleName;
        private String distinguishedName;
        private Principal principal;

        private LdapRealmIdentity(String simpleName, String distinguishedName) {
            this.simpleName = simpleName;
            this.distinguishedName = distinguishedName;
        }

        private LdapRealmIdentity(Principal principal) {
            assert (principal instanceof NamePrincipal || principal instanceof X500Principal);
            if (principal instanceof NamePrincipal) {
                if (LdapSecurityRealm.this.principalMapping.principalUseDn) {
                    this.distinguishedName = principal.getName();
                } else {
                    this.simpleName = principal.getName();
                }
            } else {
                this.distinguishedName = principal.getName();
            }
            this.principal = principal;
        }

        private void loadNames() {
            if (!this.loadedNames) {
                try {
                    NamePair np = LdapSecurityRealm.this.loadNamePair(this.simpleName, this.distinguishedName);
                    this.loadedNames = true;
                    this.simpleName = np.simpleName;
                    this.distinguishedName = np.distinguishedName;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Principal getPrincipal() {
            if (this.principal == null) {
                this.loadNames();
                if (this.loadedNames) {
                    if (LdapSecurityRealm.this.principalMapping.principalUseDn) {
                        try {
                            this.principal = new X500Principal(this.distinguishedName);
                        }
                        catch (IllegalArgumentException ignored) {
                            this.principal = new NamePrincipal(this.distinguishedName);
                        }
                    } else {
                        this.principal = new NamePrincipal(this.simpleName);
                    }
                }
            }
            return this.principal;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) {
            if (LdapSecurityRealm.this.getCredentialSupport(credentialType) == CredentialSupport.UNSUPPORTED) {
                return CredentialSupport.UNSUPPORTED;
            }
            CredentialSupport support = null;
            this.loadNames();
            for (CredentialLoader current : LdapSecurityRealm.this.credentialLoaders) {
                if (!current.getCredentialSupport(LdapSecurityRealm.this.dirContextFactory, credentialType).mayBeObtainable()) continue;
                IdentityCredentialLoader icl = current.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.distinguishedName);
                CredentialSupport temp = icl.getCredentialSupport(credentialType);
                if (temp != null && temp.isDefinitelyObtainable()) {
                    return temp;
                }
                if (support != null && support.compareTo(temp) >= 0) continue;
                support = temp;
            }
            if (support == null) {
                return CredentialSupport.UNSUPPORTED;
            }
            return support;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) {
            if (LdapSecurityRealm.this.getCredentialSupport(credentialType) == CredentialSupport.UNSUPPORTED) {
                return null;
            }
            this.loadNames();
            for (CredentialLoader current : LdapSecurityRealm.this.credentialLoaders) {
                IdentityCredentialLoader icl;
                C credential;
                if (!current.getCredentialSupport(LdapSecurityRealm.this.dirContextFactory, credentialType).mayBeObtainable() || (credential = (icl = current.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.distinguishedName)).getCredential(credentialType)) == null) continue;
                return credential;
            }
            return null;
        }

        @Override
        public void dispose() {
        }

        @Override
        public AuthenticatedRealmIdentity getAuthenticatedRealmIdentity() {
            return new AuthenticatedRealmIdentity(){

                @Override
                public Principal getPrincipal() {
                    return LdapRealmIdentity.this.principal;
                }

                @Override
                public void dispose() {
                }
            };
        }

        @Override
        public boolean verifyCredential(Object credential) {
            return false;
        }
    }
}

