/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.client.CipherSuiteSelectorAuthenticationConfiguration;
import org.wildfly.security.auth.client.ClientSSLConfigurator;
import org.wildfly.security.auth.client.ConfigurationKeyManager;
import org.wildfly.security.auth.client.FilterSaslMechanismAuthenticationConfiguration;
import org.wildfly.security.auth.client.ProtocolSelectorAuthenticationConfiguration;
import org.wildfly.security.auth.client.ProvidersAuthenticationConfiguration;
import org.wildfly.security.auth.client.RewriteNameAuthenticationConfiguration;
import org.wildfly.security.auth.client.SSLClientCertificateConfiguration;
import org.wildfly.security.auth.client.SSLClientKeyManagerConfiguration;
import org.wildfly.security.auth.client.SSLContextAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAuthorizationNameAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetHostAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPortAuthenticationConfiguration;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.util.ServiceLoaderSupplier;
import org.wildfly.security.x500.X509CertificateChainPrivateCredential;

public abstract class AuthenticationConfiguration {
    public static final AuthenticationConfiguration EMPTY = new AuthenticationConfiguration(){

        @Override
        void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException {
            CallbackUtil.unsupported(callbacks[index]);
        }

        @Override
        void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int length = callbacks.length;
            for (int i = 0; i < length; ++i) {
                config.handleCallback(callbacks, i);
            }
        }

        @Override
        void configureSaslProperties(Map<String, Object> properties) {
        }

        @Override
        void filterSaslMechanisms(Collection<String> names) {
        }

        @Override
        String doRewriteUser(String original) {
            return original;
        }

        @Override
        AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
            return this;
        }

        @Override
        AuthenticationConfiguration without(Class<? extends AuthenticationConfiguration> clazz) {
            return this;
        }

        @Override
        String getHost(URI uri) {
            return uri.getHost();
        }

        @Override
        int getPort(URI uri) {
            return uri.getPort();
        }

        @Override
        Principal getPrincipal() {
            return AnonymousPrincipal.getInstance();
        }

        @Override
        SSLContext getSslContext() {
            return null;
        }

        @Override
        void configureSslEngine(SSLEngine sslEngine) {
        }

        @Override
        void configureSslSocket(SSLSocket sslSocket) {
        }

        @Override
        ProtocolSelector getProtocolSelector() {
            return ProtocolSelector.defaultProtocols();
        }

        @Override
        CipherSuiteSelector getCipherSuiteSelector() {
            return CipherSuiteSelector.openSslDefault();
        }

        @Override
        SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
            return SSLUtils.getDefaultX509TrustManagerSecurityFactory();
        }

        @Override
        SecurityFactory<X509KeyManager> getX509KeyManagerFactory() {
            return null;
        }

        @Override
        void configureKeyManager(ConfigurationKeyManager.Builder builder) {
        }

        @Override
        Supplier<Provider[]> getProviderSupplier() {
            return Security::getProviders;
        }
    }.useAnonymous();
    private final AuthenticationConfiguration parent;
    private final CallbackHandler callbackHandler = callbacks -> this.handleCallbacks(this, callbacks);

    AuthenticationConfiguration() {
        this.parent = null;
    }

    AuthenticationConfiguration(AuthenticationConfiguration parent) {
        this(parent, false);
    }

    AuthenticationConfiguration(AuthenticationConfiguration parent, boolean allowMultiple) {
        this.parent = allowMultiple ? parent : parent.without(this.getClass());
    }

    Principal getPrincipal() {
        return this.parent.getPrincipal();
    }

    String getHost(URI uri) {
        return this.parent.getHost(uri);
    }

    int getPort(URI uri) {
        return this.parent.getPort(uri);
    }

    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        this.parent.handleCallback(callbacks, index);
    }

    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.parent.handleCallbacks(config, callbacks);
    }

    void configureSaslProperties(Map<String, Object> properties) {
        this.parent.configureSaslProperties(properties);
    }

    void filterSaslMechanisms(Collection<String> names) {
        this.parent.filterSaslMechanisms(names);
    }

    String doRewriteUser(String original) {
        return this.parent.doRewriteUser(original);
    }

    String getAuthorizationName() {
        return null;
    }

    SSLContext getSslContext() {
        return this.parent.getSslContext();
    }

    void configureSslEngine(SSLEngine sslEngine) {
        this.parent.configureSslEngine(sslEngine);
    }

    void configureSslSocket(SSLSocket sslSocket) {
        this.parent.configureSslSocket(sslSocket);
    }

    ProtocolSelector getProtocolSelector() {
        return this.parent.getProtocolSelector();
    }

    CipherSuiteSelector getCipherSuiteSelector() {
        return this.parent.getCipherSuiteSelector();
    }

    Supplier<Provider[]> getProviderSupplier() {
        return this.parent.getProviderSupplier();
    }

    SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
        return this.parent.getX509TrustManagerFactory();
    }

    SecurityFactory<X509KeyManager> getX509KeyManagerFactory() throws GeneralSecurityException {
        return this.parent.getX509KeyManagerFactory();
    }

    void configureKeyManager(ConfigurationKeyManager.Builder builder) throws GeneralSecurityException {
        this.parent.configureKeyManager(builder);
    }

    abstract AuthenticationConfiguration reparent(AuthenticationConfiguration var1);

    AuthenticationConfiguration without(Class<? extends AuthenticationConfiguration> clazz) {
        if (clazz.isInstance(this)) {
            return this.parent;
        }
        AuthenticationConfiguration newParent = this.parent.without(clazz);
        if (this.parent == newParent) {
            return this;
        }
        return this.reparent(newParent);
    }

    public AuthenticationConfiguration rewriteUser(NameRewriter rewriter) {
        if (rewriter == null) {
            return this;
        }
        return new RewriteNameAuthenticationConfiguration(this, rewriter);
    }

    public AuthenticationConfiguration useAnonymous() {
        return new SetAnonymousAuthenticationConfiguration(this);
    }

    public AuthenticationConfiguration usePrincipal(NamePrincipal principal) {
        return new SetNamePrincipalAuthenticationConfiguration(this, principal);
    }

    public AuthenticationConfiguration useName(String name) {
        return this.usePrincipal(new NamePrincipal(name));
    }

    public AuthenticationConfiguration useAuthorizationName(String name) {
        return new SetAuthorizationNameAuthenticationConfiguration(this, name);
    }

    public AuthenticationConfiguration usePassword(Password password) {
        return password == null ? this : new SetPasswordAuthenticationConfiguration(this, password);
    }

    public AuthenticationConfiguration usePassword(char[] password) {
        try {
            return password == null ? this : this.usePassword(PasswordFactory.getInstance("clear").generatePassword(new ClearPasswordSpec(password)));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException();
        }
    }

    public AuthenticationConfiguration usePassword(String password) {
        return password == null ? this : this.usePassword(password.toCharArray());
    }

    public AuthenticationConfiguration usePasswordCallback(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : new SetPasswordCallbackHandlerAuthenticationConfiguration(this, callbackHandler);
    }

    public AuthenticationConfiguration useCallbackHandler(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : new SetCallbackHandlerAuthenticationConfiguration(this, callbackHandler);
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore.Entry keyStoreEntry) {
        return keyStoreEntry == null ? this : new SetKeyStoreCredentialAuthenticationConfiguration(this, new FixedSecurityFactory<KeyStore.Entry>(keyStoreEntry));
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias) {
        return keyStore == null || alias == null ? this : new SetKeyStoreCredentialAuthenticationConfiguration(this, keyStore, alias, null);
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        return keyStore == null || alias == null ? this : new SetKeyStoreCredentialAuthenticationConfiguration(this, keyStore, alias, protectionParameter);
    }

    public AuthenticationConfiguration useHost(String hostName) {
        if (hostName != null && hostName.isEmpty()) {
            hostName = null;
        }
        return new SetHostAuthenticationConfiguration(this, hostName);
    }

    public AuthenticationConfiguration usePort(int port) {
        if (port < 1 || port > 65535) {
            throw ElytronMessages.log.invalidPortNumber(port);
        }
        return new SetPortAuthenticationConfiguration(this, port);
    }

    public AuthenticationConfiguration useProviders(Supplier<Provider[]> providerSupplier) {
        return providerSupplier == null ? this.useDefaultProviders() : new ProvidersAuthenticationConfiguration(this, providerSupplier);
    }

    public AuthenticationConfiguration useDefaultProviders() {
        return this.without(ProvidersAuthenticationConfiguration.class);
    }

    public AuthenticationConfiguration useProvidersFromClassLoader(ClassLoader classLoader) {
        return this.useProviders(new ServiceLoaderSupplier<Provider>(Provider.class, classLoader));
    }

    public AuthenticationConfiguration allowSaslMechanisms(String ... names) {
        return names == null || names.length == 0 ? new FilterSaslMechanismAuthenticationConfiguration(this, true, Collections.emptySet()) : new FilterSaslMechanismAuthenticationConfiguration(this, true, new HashSet<String>(Arrays.asList(names)));
    }

    public AuthenticationConfiguration forbidSaslMechanisms(String ... names) {
        return names == null || names.length == 0 ? this : new FilterSaslMechanismAuthenticationConfiguration(this, false, new HashSet<String>(Arrays.asList(names)));
    }

    public AuthenticationConfiguration useSslProtocolSelector(ProtocolSelector protocolSelector) {
        return protocolSelector == null ? this.without(ProtocolSelectorAuthenticationConfiguration.class) : new ProtocolSelectorAuthenticationConfiguration(this, protocolSelector);
    }

    public AuthenticationConfiguration useSslCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
        return cipherSuiteSelector == null ? this.without(CipherSuiteSelectorAuthenticationConfiguration.class) : new CipherSuiteSelectorAuthenticationConfiguration(this, cipherSuiteSelector);
    }

    public AuthenticationConfiguration useSslContext(SSLContext sslContext) {
        return sslContext == null ? this.without(SSLContextAuthenticationConfiguration.class) : new SSLContextAuthenticationConfiguration(this, sslContext);
    }

    public AuthenticationConfiguration useSslClientCredential(PrivateKey privateKey, X509Certificate ... certificateChain) {
        return certificateChain == null || certificateChain.length == 0 || privateKey == null ? this.without(SSLClientCertificateConfiguration.class) : this.useSslClientCredential(new X509CertificateChainPrivateCredential(privateKey, certificateChain));
    }

    public AuthenticationConfiguration useSslClientCredential(X509CertificateChainPrivateCredential credential) {
        return credential == null ? this.without(SSLClientCertificateConfiguration.class) : this.useSslClientCredential(new FixedSecurityFactory<X509CertificateChainPrivateCredential>(credential));
    }

    public AuthenticationConfiguration useSslClientCredential(SecurityFactory<X509CertificateChainPrivateCredential> credentialFactory) {
        return credentialFactory == null ? this.without(SSLClientCertificateConfiguration.class) : new SSLClientCertificateConfiguration(this, credentialFactory);
    }

    public AuthenticationConfiguration useSslClientKeyManager(X509KeyManager keyManager) {
        return keyManager == null ? this.without(SSLClientKeyManagerConfiguration.class) : new SSLClientKeyManagerConfiguration(this, new FixedSecurityFactory<X509KeyManager>(keyManager));
    }

    CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    SaslClient createSaslClient(URI uri, SaslClientFactory clientFactory, Collection<String> serverMechanisms) throws SaslException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.configureSaslProperties(properties);
        HashSet<String> mechs = new HashSet<String>(serverMechanisms);
        this.filterSaslMechanisms(mechs);
        String authorizationName = this.getAuthorizationName();
        CallbackHandler callbackHandler = this.getCallbackHandler();
        return clientFactory.createSaslClient(mechs.toArray(new String[mechs.size()]), authorizationName, uri.getScheme(), this.getHost(uri), properties, callbackHandler);
    }

    InetSocketAddress getDestinationInetAddress(URI uri, int defaultPort) {
        String host = this.getHost(uri);
        int port = this.getPort(uri);
        if (port == -1) {
            port = defaultPort;
        }
        return new InetSocketAddress(host, port);
    }

    SSLContext createSslContext() throws GeneralSecurityException {
        SSLContext sslContext = this.getSslContext();
        if (sslContext == null) {
            sslContext = SSLContext.getDefault();
        } else {
            KeyManager keyManager;
            SecurityFactory<SSLContext> sslContextFactory = SSLUtils.createSslContextFactory(this.getProtocolSelector(), this.getProviderSupplier());
            sslContext = sslContextFactory.create();
            SecurityFactory<X509KeyManager> keyManagerFactory = this.getX509KeyManagerFactory();
            if (keyManagerFactory != null) {
                keyManager = keyManagerFactory.create();
            } else {
                ConfigurationKeyManager.Builder builder = new ConfigurationKeyManager.Builder();
                this.configureKeyManager(builder);
                keyManager = builder.build();
            }
            KeyManager[] keyManagers = new KeyManager[]{keyManager};
            SecurityFactory<X509TrustManager> trustManagerFactory = this.getX509TrustManagerFactory();
            TrustManager trustManager = trustManagerFactory != null ? (TrustManager)trustManagerFactory.create() : null;
            TrustManager[] trustManagers = new TrustManager[]{trustManager};
            sslContext.init(keyManagers, trustManagers, null);
        }
        return SSLUtils.createConfiguredSslContext(sslContext, new ClientSSLConfigurator(this));
    }
}

