/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.jdbc;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.jdbc.ColumnMapper;
import org.wildfly.security.auth.provider.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.provider.jdbc.KeyMapper;
import org.wildfly.security.auth.provider.jdbc.QueryConfiguration;
import org.wildfly.security.auth.provider.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;

public class JdbcSecurityRealm
implements SecurityRealm {
    private final List<QueryConfiguration> queryConfiguration;

    public static JdbcSecurityRealmBuilder builder() {
        return new JdbcSecurityRealmBuilder();
    }

    JdbcSecurityRealm(List<QueryConfiguration> queryConfiguration) {
        this.queryConfiguration = queryConfiguration;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        return new JdbcRealmIdentity(name);
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
        for (QueryConfiguration configuration : this.queryConfiguration) {
            for (ColumnMapper mapper : configuration.getColumnMappers()) {
                KeyMapper keyMapper;
                if (!KeyMapper.class.isInstance(mapper) || !credentialType.equals((keyMapper = (KeyMapper)mapper).getKeyType())) continue;
                return CredentialSupport.UNKNOWN;
            }
        }
        return CredentialSupport.UNSUPPORTED;
    }

    private static interface ResultSetCallback<E> {
        public E handle(ResultSet var1);
    }

    private class JdbcRealmIdentity
    implements RealmIdentity {
        private final String name;

        public JdbcRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (ColumnMapper mapper : configuration.getColumnMappers()) {
                    KeyMapper keyMapper;
                    if (!KeyMapper.class.isInstance(mapper) || !(keyMapper = (KeyMapper)mapper).getKeyType().isAssignableFrom(credentialType)) continue;
                    return this.executeAuthenticationQuery(configuration, keyMapper::getCredentialSupport);
                }
            }
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (ColumnMapper mapper : configuration.getColumnMappers()) {
                    KeyMapper keyMapper;
                    if (!KeyMapper.class.isInstance(mapper) || !(keyMapper = (KeyMapper)mapper).getKeyType().isAssignableFrom(credentialType)) continue;
                    return (C)this.executeAuthenticationQuery(configuration, resultSet -> keyMapper.map(resultSet));
                }
            }
            return null;
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            if (credential == null) {
                return false;
            }
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (ColumnMapper mapper : configuration.getColumnMappers()) {
                    KeyMapper credentialMapper;
                    if (!KeyMapper.class.isInstance(mapper) || !Password.class.isAssignableFrom((credentialMapper = (KeyMapper)mapper).getKeyType())) continue;
                    PasswordKeyMapper passwordMapper = (PasswordKeyMapper)mapper;
                    return this.verifyPassword(configuration, passwordMapper, credential);
                }
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return new JdbcAuthorizationIdentity(this.name);
        }

        private boolean verifyPassword(QueryConfiguration configuration, PasswordKeyMapper passwordMapper, Object givenCredential) {
            Object credential = this.executeAuthenticationQuery(configuration, passwordMapper::map);
            String algorithm = passwordMapper.getAlgorithm();
            try {
                if (Password.class.isInstance(credential)) {
                    char[] guessCredentialChars;
                    PasswordFactory passwordFactory = this.getPasswordFactory(algorithm);
                    if (String.class.equals(givenCredential.getClass())) {
                        guessCredentialChars = givenCredential.toString().toCharArray();
                    } else if (char[].class.equals(givenCredential.getClass())) {
                        guessCredentialChars = (char[])givenCredential;
                    } else if (ClearPassword.class.isInstance(givenCredential)) {
                        guessCredentialChars = ((ClearPassword)givenCredential).getPassword();
                    } else {
                        throw ElytronMessages.log.passwordBasedCredentialsMustBeStringCharsOrClearPassword();
                    }
                    return passwordFactory.verify((Password)credential, guessCredentialChars);
                }
            }
            catch (InvalidKeyException e) {
                throw ElytronMessages.log.invalidPasswordKeyForAlgorithm(algorithm, e);
            }
            return false;
        }

        private PasswordFactory getPasswordFactory(String algorithm) {
            try {
                return PasswordFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.couldNotObtainPasswordFactoryForAlgorithm(algorithm, e);
            }
        }

        private Connection getConnection(QueryConfiguration configuration) {
            Connection connection;
            try {
                DataSource dataSource = configuration.getDataSource();
                connection = dataSource.getConnection();
            }
            catch (Exception e) {
                throw ElytronMessages.log.couldNotOpenConnection(e);
            }
            return connection;
        }

        private void safeClose(AutoCloseable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <E> E executeAuthenticationQuery(QueryConfiguration configuration, ResultSetCallback<E> resultSetCallback) {
            String sql = configuration.getSql();
            Connection connection = this.getConnection(configuration);
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, this.getName());
                resultSet = preparedStatement.executeQuery();
                E e = resultSetCallback.handle(resultSet);
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                return e;
            }
            catch (SQLException e2) {
                try {
                    throw ElytronMessages.log.couldNotExecuteQuery(sql, e2);
                    catch (Exception e22) {
                        throw ElytronMessages.log.unexpectedErrorWhenProcessingAuthenticationQuery(sql, e22);
                    }
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
        }

        private class JdbcAuthorizationIdentity
        implements AuthorizationIdentity {
            private String name;

            JdbcAuthorizationIdentity(String name) {
                this.name = name;
            }
        }
    }
}

