/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.AuthorizationIdentity;

public interface RealmIdentity {
    public static final RealmIdentity ANONYMOUS = new RealmIdentity(){

        @Override
        public String getName() {
            return "anonymous";
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
            return CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return AuthorizationIdentity.EMPTY;
        }
    };

    public String getName();

    public CredentialSupport getCredentialSupport(Class<?> var1) throws RealmUnavailableException;

    public <C> C getCredential(Class<C> var1) throws RealmUnavailableException;

    public boolean verifyCredential(Object var1) throws RealmUnavailableException;

    public boolean exists() throws RealmUnavailableException;

    default public void dispose() {
    }

    public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException;

    public static RealmIdentity nonExistentIdentity(final String name) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        return new RealmIdentity(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public CredentialSupport getCredentialSupport(Class<?> credentialType) throws RealmUnavailableException {
                return CredentialSupport.UNSUPPORTED;
            }

            @Override
            public <C> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            @Override
            public boolean verifyCredential(Object credential) throws RealmUnavailableException {
                return false;
            }

            @Override
            public boolean exists() throws RealmUnavailableException {
                return false;
            }

            @Override
            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                throw ElytronMessages.log.userDoesNotExist();
            }
        };
    }
}

