/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import org.wildfly.security.util.ByteStringBuilder;

class SaslQuote {
    private static final char QUOTE = '\\';

    private SaslQuote() {
    }

    private static boolean quoteNeeded(char ch) {
        return ch == '\"' || ch == '\\' || ch == '\u007f' || ch >= '\u0000' && ch <= '\u001f' && ch != '\r' && ch != '\n' && ch != '\t';
    }

    static String quote(String inputStr) {
        int len = inputStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = inputStr.charAt(i);
            if (SaslQuote.quoteNeeded(ch)) {
                sb.append('\\').append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static byte[] quote(byte[] input) {
        ByteStringBuilder bsb = new ByteStringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (SaslQuote.quoteNeeded((char)input[i])) {
                bsb.append('\\');
                bsb.append(input, i, 1);
                continue;
            }
            bsb.append(input, i, 1);
        }
        return bsb.toArray();
    }
}

