/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import org.wildfly.security.auth.server.CredentialSupport;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;

public final class AggregateSecurityRealm
implements SecurityRealm {
    private final SecurityRealm authenticationRealm;
    private final SecurityRealm authorizationRealm;

    public AggregateSecurityRealm(SecurityRealm authenticationRealm, SecurityRealm authorizationRealm) {
        this.authenticationRealm = authenticationRealm;
        this.authorizationRealm = authorizationRealm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        boolean ok = false;
        RealmIdentity authenticationIdentity = this.authenticationRealm.createRealmIdentity(name);
        try {
            RealmIdentity authorizationIdentity = this.authorizationRealm.createRealmIdentity(name);
            try {
                Identity identity = new Identity(name, authenticationIdentity, authorizationIdentity);
                ok = true;
                Identity identity2 = identity;
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                return identity2;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    authorizationIdentity.dispose();
                }
                throw throwable;
            }
        }
        finally {
            if (!ok) {
                authenticationIdentity.dispose();
            }
        }
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) throws RealmUnavailableException {
        return this.authenticationRealm.getCredentialSupport(credentialType, algorithmName);
    }

    static final class Identity
    implements RealmIdentity {
        private final String name;
        private final RealmIdentity authenticationIdentity;
        private final RealmIdentity authorizationIdentity;

        Identity(String name, RealmIdentity authenticationIdentity, RealmIdentity authorizationIdentity) {
            this.name = name;
            this.authenticationIdentity = authenticationIdentity;
            this.authorizationIdentity = authorizationIdentity;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredentialSupport(credentialType, null);
        }

        @Override
        public <C> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return this.authenticationIdentity.getCredential(credentialType, algorithmName);
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            return this.authenticationIdentity.verifyCredential(credential);
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.authenticationIdentity.exists();
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.authorizationIdentity.exists() ? this.authorizationIdentity.getAuthorizationIdentity() : AuthorizationIdentity.EMPTY;
        }

        @Override
        public void dispose() {
            this.authenticationIdentity.dispose();
            this.authorizationIdentity.dispose();
        }
    }
}

