/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.sasl.digest.AbstractDigestMechanism;
import org.wildfly.security.sasl.digest.SaslQuote;
import org.wildfly.security.sasl.digest._private.DigestUtil;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.DefaultTransformationMapper;
import org.wildfly.security.util.TransformationSpec;

class DigestSaslClient
extends AbstractDigestMechanism
implements SaslClient {
    private static final byte STEP_TWO = 2;
    private static final byte STEP_FOUR = 4;
    private String[] realms;
    private String[] clientQops;
    private boolean stale = false;
    private int maxbuf = 65536;
    private String cipher_opts;
    private final String authorizationId;
    private final boolean hasInitialResponse;
    private final String[] demandedCiphers;
    private final MessageDigest messageDigest;

    DigestSaslClient(String mechanism, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, boolean hasInitialResponse, Charset charset, String[] qops, String[] ciphers) throws SaslException {
        super(mechanism, protocol, serverName, callbackHandler, AbstractDigestMechanism.FORMAT.CLIENT, charset, ciphers);
        this.hasInitialResponse = hasInitialResponse;
        this.authorizationId = authorizationId;
        this.clientQops = qops == null ? DigestUtil.QOP_VALUES : qops;
        this.demandedCiphers = ciphers == null ? new String[]{} : ciphers;
        try {
            this.messageDigest = MessageDigest.getInstance(DigestUtil.messageDigestAlgorithm(mechanism));
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.saslMacAlgorithmNotSupported(this.getMechanismName(), e);
        }
    }

    private void noteChallengeData(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        LinkedList<String> realmList = new LinkedList<String>();
        for (String keyWord : parsedChallenge.keySet()) {
            if (keyWord.startsWith("realm")) {
                realmList.add(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                continue;
            }
            if (keyWord.equals("qop")) {
                String serverQops = new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8);
                this.qop = this.selectQop(serverQops.split(String.valueOf(',')), this.clientQops);
                continue;
            }
            if (keyWord.equals("stale")) {
                this.stale = Boolean.parseBoolean(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                continue;
            }
            if (keyWord.equals("maxbuf")) {
                int maxbuf = Integer.parseInt(new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8));
                if (maxbuf <= 0) continue;
                this.maxbuf = maxbuf;
                continue;
            }
            if (keyWord.equals("nonce")) {
                this.nonce = parsedChallenge.get(keyWord);
                continue;
            }
            if (!keyWord.equals("cipher")) continue;
            this.cipher_opts = new String(parsedChallenge.get(keyWord), StandardCharsets.UTF_8);
            this.cipher = this.selectCipher(this.cipher_opts);
        }
        if (this.qop != null && !this.qop.equals("auth")) {
            this.setWrapper(new AbstractDigestMechanism.DigestWrapper(this, this.qop.equals("auth-conf")));
        }
        this.realms = new String[realmList.size()];
        realmList.toArray(this.realms);
    }

    private String selectQop(String[] serverQops, String[] clientQops) throws SaslException {
        for (String clientQop : clientQops) {
            if (!this.arrayContains(serverQops, clientQop)) continue;
            return clientQop;
        }
        throw ElytronMessages.log.saslNoCommonProtectionLayer(this.getMechanismName());
    }

    private String selectCipher(String ciphersFromServer) throws SaslException {
        if (ciphersFromServer == null) {
            throw ElytronMessages.log.saslNoCiphersOfferedByServer(this.getMechanismName());
        }
        DefaultTransformationMapper trans = new DefaultTransformationMapper();
        String[] tokensToChooseFrom = ciphersFromServer.split(String.valueOf(','));
        for (TransformationSpec ts : trans.getTransformationSpecByStrength("DIGEST-MD5", tokensToChooseFrom)) {
            for (String c : this.demandedCiphers) {
                if (!c.equals(ts.getToken())) continue;
                return ts.getToken();
            }
        }
        throw ElytronMessages.log.saslNoCommonCipher(this.getMechanismName());
    }

    private byte[] createResponse(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        byte[] digestURP;
        String passwordAlgorithm;
        String chs;
        ByteStringBuilder digestResponse = new ByteStringBuilder();
        byte[] chb = parsedChallenge.get("charset");
        Charset serverHashedURPUsingcharset = chb != null ? ("utf-8".equals(chs = new String(chb, StandardCharsets.UTF_8)) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1) : StandardCharsets.ISO_8859_1;
        if (StandardCharsets.UTF_8.equals(serverHashedURPUsingcharset)) {
            digestResponse.append("charset=");
            digestResponse.append("utf-8");
            digestResponse.append(',');
        }
        NameCallback nameCallback = this.authorizationId != null ? new NameCallback("User name", this.authorizationId) : new NameCallback("User name");
        switch (this.getMechanismName()) {
            case "DIGEST-MD5": {
                passwordAlgorithm = "digest-md5";
                break;
            }
            case "DIGEST-SHA": {
                passwordAlgorithm = "digest-sha";
                break;
            }
            case "DIGEST-SHA-256": {
                passwordAlgorithm = "digest-sha-256";
                break;
            }
            case "DIGEST-SHA-384": {
                passwordAlgorithm = "digest-sha-384";
                break;
            }
            case "DIGEST-SHA-512": {
                passwordAlgorithm = "digest-sha-512";
                break;
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)this.getMechanismName());
            }
        }
        CredentialCallback credentialCallback = new CredentialCallback(Collections.singletonMap(DigestPassword.class, Collections.singleton(passwordAlgorithm)));
        PasswordCallback passwordCallback = new PasswordCallback("User password", false);
        String userName = null;
        String realm = null;
        try {
            if (this.realms != null && this.realms.length > 1) {
                RealmChoiceCallback realmChoiceCallBack = new RealmChoiceCallback("User realm", this.realms, 0, false);
                this.tryHandleCallbacks(realmChoiceCallBack, nameCallback, credentialCallback);
                realm = this.realms[realmChoiceCallBack.getSelectedIndexes()[0]];
            } else if (this.realms != null && this.realms.length == 1) {
                RealmCallback realmCallback = new RealmCallback("User realm", this.realms[0]);
                this.tryHandleCallbacks(realmCallback, nameCallback, credentialCallback);
                realm = realmCallback.getText();
            } else {
                this.tryHandleCallbacks(nameCallback, credentialCallback);
            }
            userName = nameCallback.getName();
            DigestPassword digestedPassword = (DigestPassword)credentialCallback.getCredential();
            if (!passwordAlgorithm.equals(digestedPassword.getAlgorithm())) {
                throw new FastUnsupportedCallbackException(credentialCallback);
            }
            digestURP = digestedPassword.getDigest();
            if (userName == null) {
                throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), null);
            }
            if (digestURP == null) {
                throw ElytronMessages.log.saslNotProvidedPreDigested(this.getMechanismName());
            }
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() == credentialCallback) {
                if (this.realms != null && this.realms.length > 1) {
                    RealmChoiceCallback realmChoiceCallBack = new RealmChoiceCallback("User realm", this.realms, 0, false);
                    this.handleCallbacks(realmChoiceCallBack, nameCallback, passwordCallback);
                    realm = this.realms[realmChoiceCallBack.getSelectedIndexes()[0]];
                } else if (this.realms != null && this.realms.length == 1) {
                    RealmCallback realmCallback = new RealmCallback("User realm", this.realms[0]);
                    this.handleCallbacks(realmCallback, nameCallback, passwordCallback);
                    realm = realmCallback.getText();
                } else {
                    this.handleCallbacks(nameCallback, passwordCallback);
                }
                userName = nameCallback.getName();
                char[] clearPassword = passwordCallback.getPassword();
                passwordCallback.clearPassword();
                if (userName == null) {
                    throw ElytronMessages.log.saslCallbackHandlerDoesNotSupportUserName(this.getMechanismName(), null);
                }
                if (clearPassword == null) {
                    ElytronMessages.log.saslNotProvidedClearPassword(this.getMechanismName());
                }
                digestURP = DigestUtil.userRealmPasswordDigest(this.messageDigest, userName, realm, clearPassword);
                Arrays.fill(clearPassword, '\u0000');
            }
            throw ElytronMessages.log.saslCallbackHandlerFailedForUnknownReason(this.getMechanismName(), e);
        }
        digestResponse.append("username=\"");
        digestResponse.append(SaslQuote.quote(userName).getBytes(serverHashedURPUsingcharset));
        digestResponse.append("\"").append(',');
        if (realm != null) {
            digestResponse.append("realm=\"");
            digestResponse.append(SaslQuote.quote(realm).getBytes(serverHashedURPUsingcharset));
            digestResponse.append("\"").append(',');
        }
        if (this.nonce == null) {
            throw ElytronMessages.log.saslMissingDirective(this.getMechanismName(), "nonce");
        }
        digestResponse.append("nonce=\"");
        digestResponse.append(this.nonce);
        digestResponse.append("\"").append(',');
        digestResponse.append("nc=");
        int nonceCount = this.getNonceCount();
        digestResponse.append(DigestUtil.convertToHexBytesWithLeftPadding(nonceCount, 8));
        digestResponse.append(',');
        digestResponse.append("cnonce=\"");
        this.cnonce = DigestSaslClient.generateNonce();
        digestResponse.append(this.cnonce);
        digestResponse.append("\"").append(',');
        digestResponse.append("digest-uri=\"");
        digestResponse.append(this.digestURI);
        digestResponse.append("\"").append(',');
        digestResponse.append("maxbuf=");
        digestResponse.append(String.valueOf(this.maxbuf));
        digestResponse.append(',');
        this.hA1 = DigestUtil.H_A1(this.messageDigest, digestURP, this.nonce, this.cnonce, this.authorizationId, serverHashedURPUsingcharset);
        byte[] response_value = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, nonceCount, this.cnonce, this.authorizationId, this.qop, this.digestURI, true);
        digestResponse.append("response=");
        digestResponse.append(response_value);
        digestResponse.append(',');
        digestResponse.append("qop=");
        digestResponse.append(this.qop != null ? this.qop : "auth");
        if (this.cipher != null && this.cipher.length() != 0) {
            digestResponse.append(',');
            digestResponse.append("cipher=\"");
            digestResponse.append(this.cipher);
            digestResponse.append("\"");
        }
        if (this.authorizationId != null) {
            digestResponse.append(',');
            digestResponse.append("authzid=\"");
            digestResponse.append(SaslQuote.quote(this.authorizationId).getBytes(serverHashedURPUsingcharset));
            digestResponse.append("\"");
        }
        this.createCiphersAndKeys();
        return digestResponse.toArray();
    }

    private int getNonceCount() {
        return 1;
    }

    private void checkResponseAuth(HashMap<String, byte[]> parsedChallenge) throws SaslException {
        byte[] expected = DigestUtil.digestResponse(this.messageDigest, this.hA1, this.nonce, this.getNonceCount(), this.cnonce, this.authzid, this.qop, this.digestURI, false);
        if (!Arrays.equals(expected, parsedChallenge.get("rspauth"))) {
            throw ElytronMessages.log.saslServerAuthenticityCannotBeVerified(this.getMechanismName());
        }
    }

    @Override
    public void init() {
        this.setNegotiationState(2);
    }

    @Override
    public boolean hasInitialResponse() {
        return this.hasInitialResponse;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        return this.evaluateMessage(challenge);
    }

    @Override
    protected byte[] evaluateMessage(int state, byte[] message) throws SaslException {
        HashMap<String, byte[]> parsedChallenge = this.parseResponse(message);
        switch (state) {
            case 2: {
                this.noteChallengeData(parsedChallenge);
                this.setNegotiationState(4);
                return this.createResponse(parsedChallenge);
            }
            case 4: {
                this.checkResponseAuth(parsedChallenge);
                this.negotiationComplete();
                return null;
            }
        }
        throw Assert.impossibleSwitchCase((int)state);
    }
}

