/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500PrivateCredential;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.KeyStoreEntrySecurityFactory;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateURLCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.x500.X509CertificateChainPrivateCredential;

class SetKeyStoreCredentialAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<KeyStore.Entry> entryFactory;

    SetKeyStoreCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        this(parent, new OneTimeSecurityFactory<KeyStore.Entry>(new KeyStoreEntrySecurityFactory(keyStore, alias, protectionParameter)));
    }

    SetKeyStoreCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<KeyStore.Entry> entryFactory) {
        super(parent.without(SetPasswordAuthenticationConfiguration.class).without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class).without(SetCertificateURLCredentialAuthenticationConfiguration.class));
        this.entryFactory = entryFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetKeyStoreCredentialAuthenticationConfiguration(newParent, this.entryFactory);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            KeyStore.Entry entry;
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            try {
                entry = this.entryFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToReadCredential(e);
            }
            if (entry instanceof PasswordEntry) {
                credentialCallback.setCredential(((PasswordEntry)entry).getPassword());
                return;
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                Certificate[] certificateChain = privateKeyEntry.getCertificateChain();
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                if (certificateChain == null || certificateChain.length == 0) {
                    credentialCallback.setCredential(privateKey);
                    return;
                }
                Certificate certificate = privateKeyEntry.getCertificate();
                if (certificate instanceof X509Certificate && credentialCallback.isCredentialSupported(X500PrivateCredential.class, privateKey.getAlgorithm())) {
                    credentialCallback.setCredential(new X500PrivateCredential((X509Certificate)certificate, privateKey));
                    return;
                }
                if (certificateChain instanceof X509Certificate[] && credentialCallback.isCredentialSupported(X509CertificateChainPrivateCredential.class, privateKey.getAlgorithm())) {
                    credentialCallback.setCredential(new X509CertificateChainPrivateCredential(privateKey, (X509Certificate[])certificateChain));
                    return;
                }
            } else {
                if (entry instanceof KeyStore.TrustedCertificateEntry) {
                    credentialCallback.setCredential(((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate());
                    return;
                }
                if (entry instanceof KeyStore.SecretKeyEntry) {
                    credentialCallback.setCredential(((KeyStore.SecretKeyEntry)entry).getSecretKey());
                    return;
                }
            }
        } else if (callback instanceof PasswordCallback) {
            KeyStore.Entry entry;
            try {
                entry = this.entryFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToReadCredential(e);
            }
            if (entry instanceof PasswordEntry) {
                ClearPasswordSpec keySpec;
                Password realPassword;
                PasswordFactory passwordFactory;
                Password password = ((PasswordEntry)entry).getPassword();
                try {
                    passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw ElytronMessages.log.unableToReadCredential(e);
                }
                try {
                    realPassword = passwordFactory.translate(password);
                }
                catch (InvalidKeyException e) {
                    throw ElytronMessages.log.unableToReadCredential(e);
                }
                try {
                    keySpec = passwordFactory.getKeySpec(realPassword, ClearPasswordSpec.class);
                }
                catch (InvalidKeySpecException e) {
                    throw ElytronMessages.log.unableToReadCredential(e);
                }
                ((PasswordCallback)callback).setPassword(keySpec.getEncodedPassword());
                return;
            }
        }
        super.handleCallback(callbacks, index);
    }
}

