/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerExchange;

public class HttpAuthenticator {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final HttpExchangeSpi httpExchangeSpi;
    private final boolean required;
    private final boolean ignoreOptionalFailures;
    private volatile boolean authenticated = false;

    private HttpAuthenticator(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier, HttpExchangeSpi httpExchangeSpi, boolean required, boolean ignoreOptionalFailures) {
        this.mechanismSupplier = mechanismSupplier;
        this.httpExchangeSpi = httpExchangeSpi;
        this.required = required;
        this.ignoreOptionalFailures = ignoreOptionalFailures;
    }

    public boolean authenticate() throws HttpAuthenticationException {
        return new AuthenticationExchange().authenticate();
    }

    private boolean isAuthenticated() {
        return this.authenticated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        private HttpExchangeSpi httpExchangeSpi;
        private boolean required;
        private boolean ignoreOptionalFailures;

        private Builder() {
        }

        public Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        public Builder setHttpExchangeSpi(HttpExchangeSpi httpExchangeSpi) {
            this.httpExchangeSpi = httpExchangeSpi;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setIgnoreOptionalFailures(boolean ignoreOptionalFailures) {
            this.ignoreOptionalFailures = ignoreOptionalFailures;
            return this;
        }

        public HttpAuthenticator build() {
            return new HttpAuthenticator(this.mechanismSupplier, this.httpExchangeSpi, this.required, this.ignoreOptionalFailures);
        }
    }

    private class AuthenticationExchange
    extends HttpServerExchange {
        private volatile HttpServerAuthenticationMechanism currentMechanism;
        private volatile int responseCode;
        private volatile boolean responseCodeAllowed;

        AuthenticationExchange() {
            super(HttpAuthenticator.this.httpExchangeSpi);
            this.responseCode = -1;
            this.responseCodeAllowed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean authenticate() throws HttpAuthenticationException {
            List authenticationMechanisms = (List)HttpAuthenticator.this.mechanismSupplier.get();
            try {
                boolean authenticationAttempted = false;
                Iterator iterator = authenticationMechanisms.iterator();
                while (iterator.hasNext()) {
                    HttpServerAuthenticationMechanism nextMechanism;
                    this.currentMechanism = nextMechanism = (HttpServerAuthenticationMechanism)iterator.next();
                    authenticationAttempted |= nextMechanism.evaluateRequest(this);
                    if (!HttpAuthenticator.this.isAuthenticated()) continue;
                    boolean bl = true;
                    return bl;
                }
                this.currentMechanism = null;
                if (HttpAuthenticator.this.required || authenticationAttempted && !HttpAuthenticator.this.ignoreOptionalFailures) {
                    this.responseCodeAllowed = true;
                    boolean challengeSent = false;
                    Iterator iterator2 = authenticationMechanisms.iterator();
                    while (iterator2.hasNext()) {
                        HttpServerAuthenticationMechanism nextMechanism;
                        this.currentMechanism = nextMechanism = (HttpServerAuthenticationMechanism)iterator2.next();
                        challengeSent |= nextMechanism.prepareResponse(this);
                    }
                    this.currentMechanism = null;
                    if (!challengeSent && (HttpAuthenticator.this.required || authenticationAttempted && !HttpAuthenticator.this.ignoreOptionalFailures)) {
                        HttpAuthenticator.this.httpExchangeSpi.setResponseCode(403);
                        boolean bl = false;
                        return bl;
                    }
                    if (challengeSent) {
                        HttpAuthenticator.this.httpExchangeSpi.setResponseCode(this.responseCode);
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                authenticationMechanisms.forEach(m -> m.dispose());
            }
        }

        @Override
        public void setResponseCode(int responseCode) {
            if (!this.responseCodeAllowed) {
                throw ElytronMessages.log.responseCodeNotNow();
            }
            if (this.responseCode < 0 || responseCode != 200) {
                this.responseCode = responseCode;
            }
        }

        @Override
        public void authenticationComplete(SecurityIdentity securityIdentity) {
            HttpAuthenticator.this.authenticated = true;
            HttpAuthenticator.this.httpExchangeSpi.authenticationComplete(securityIdentity, this.currentMechanism.getMechanismName());
        }

        @Override
        public void authenticationFailed(String message) {
            HttpAuthenticator.this.httpExchangeSpi.authenticationFailed(message, this.currentMechanism.getMechanismName());
        }
    }
}

