/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.plain;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.PasswordVerifyCallback;
import org.wildfly.security.sasl.util.SaslWrapper;
import org.wildfly.security.util.CodePointIterator;

final class PlainSaslServer
implements SaslServer,
SaslWrapper {
    private final CallbackHandler callbackHandler;
    private boolean complete;
    private String authorizedId;

    public PlainSaslServer(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        return this.authorizedId;
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        String password;
        String loginName;
        String authorizationId;
        if (this.complete) {
            throw ElytronMessages.log.mechMessageAfterComplete(this.getMechanismName()).toSaslException();
        }
        this.complete = true;
        if (response.length >= 65536) {
            throw ElytronMessages.log.mechMessageTooLong(this.getMechanismName()).toSaslException();
        }
        CodePointIterator i = CodePointIterator.ofUtf8Bytes(response);
        try {
            CodePointIterator delimIter = i.delimitedBy(0);
            authorizationId = delimIter.hasNext() ? delimIter.drainToString() : null;
            i.next();
            loginName = delimIter.drainToString();
            i.next();
            password = delimIter.drainToString();
            if (authorizationId == null) {
                authorizationId = loginName;
            }
        }
        catch (NoSuchElementException ignored) {
            throw ElytronMessages.log.mechInvalidMessageReceived(this.getMechanismName()).toSaslException();
        }
        NameCallback ncb = new NameCallback("PLAIN authentication identity", loginName);
        PasswordVerifyCallback pvc = new PasswordVerifyCallback(password.toCharArray());
        try {
            this.callbackHandler.handle(new Callback[]{ncb, pvc});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechServerSideAuthenticationFailed(this.getMechanismName(), e).toSaslException();
        }
        finally {
            pvc.clearPassword();
        }
        if (!pvc.isVerified()) {
            throw ElytronMessages.log.mechPasswordNotVerified(this.getMechanismName()).toSaslException();
        }
        AuthorizeCallback acb = new AuthorizeCallback(loginName, authorizationId);
        try {
            this.callbackHandler.handle(new Callback[]{acb});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw ElytronMessages.log.mechServerSideAuthenticationFailed(this.getMechanismName(), e).toSaslException();
        }
        if (!acb.isAuthorized()) {
            throw ElytronMessages.log.mechAuthorizationFailed(this.getMechanismName(), loginName, authorizationId).toSaslException();
        }
        this.authorizedId = acb.getAuthorizedID();
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        throw ElytronMessages.log.mechNoSecurityLayer(this.getMechanismName()).toSaslException();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw ElytronMessages.log.mechAuthenticationNotComplete(this.getMechanismName());
        }
        throw ElytronMessages.log.mechNoSecurityLayer(this.getMechanismName()).toSaslException();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

