/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLConfigurator;

final class ServerSSLConfigurator
implements SSLConfigurator {
    private final ProtocolSelector protocolSelector;
    private final CipherSuiteSelector cipherSuiteSelector;
    private final boolean wantClientAuth;
    private final boolean needClientAuth;

    ServerSSLConfigurator(ProtocolSelector protocolSelector, CipherSuiteSelector cipherSuiteSelector, boolean wantClientAuth, boolean needClientAuth) {
        this.protocolSelector = protocolSelector;
        this.cipherSuiteSelector = cipherSuiteSelector;
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = needClientAuth;
    }

    private void configure(SSLParameters params, String[] supportedProtocols, String[] supportedCipherSuites) {
        params.setProtocols(this.protocolSelector.evaluate(supportedProtocols));
        params.setCipherSuites(this.cipherSuiteSelector.evaluate(supportedCipherSuites));
        params.setUseCipherSuitesOrder(true);
        params.setNeedClientAuth(this.needClientAuth);
        params.setWantClientAuth(this.wantClientAuth);
    }

    @Override
    public void configure(SSLContext context, SSLServerSocket sslServerSocket) {
        sslServerSocket.setUseClientMode(false);
        SSLParameters sslParameters = sslServerSocket.getSSLParameters();
        this.configure(sslParameters, sslServerSocket.getSupportedProtocols(), sslServerSocket.getSupportedCipherSuites());
        sslServerSocket.setSSLParameters(sslParameters);
    }

    @Override
    public void configure(SSLContext context, SSLSocket sslSocket) {
        sslSocket.setUseClientMode(false);
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        this.configure(sslParameters, sslSocket.getSupportedProtocols(), sslSocket.getSupportedCipherSuites());
        sslSocket.setSSLParameters(sslParameters);
    }

    @Override
    public void configure(SSLContext context, SSLEngine sslEngine) {
        sslEngine.setUseClientMode(false);
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        this.configure(sslParameters, sslEngine.getSupportedProtocols(), sslEngine.getSupportedCipherSuites());
        sslEngine.setSSLParameters(sslParameters);
    }

    @Override
    public SSLParameters getDefaultSSLParameters(SSLContext sslContext, SSLParameters original) {
        SSLParameters supportedSSLParameters = sslContext.getSupportedSSLParameters();
        this.configure(original, supportedSSLParameters.getProtocols(), supportedSSLParameters.getCipherSuites());
        return original;
    }

    @Override
    public SSLParameters getSupportedSSLParameters(SSLContext sslContext, SSLParameters original) {
        return this.getDefaultSSLParameters(sslContext, original);
    }

    @Override
    public void setWantClientAuth(SSLContext context, SSLSocket sslSocket, boolean value) {
    }

    @Override
    public void setWantClientAuth(SSLContext context, SSLEngine sslEngine, boolean value) {
    }

    @Override
    public void setWantClientAuth(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean value) {
    }

    @Override
    public void setNeedClientAuth(SSLContext context, SSLSocket sslSocket, boolean value) {
    }

    @Override
    public void setNeedClientAuth(SSLContext context, SSLEngine sslEngine, boolean value) {
    }

    @Override
    public void setNeedClientAuth(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean value) {
    }

    @Override
    public void setEnabledCipherSuites(SSLContext sslContext, SSLSocket sslSocket, String[] cipherSuites) {
    }

    @Override
    public void setEnabledCipherSuites(SSLContext sslContext, SSLEngine sslEngine, String[] cipherSuites) {
    }

    @Override
    public void setEnabledCipherSuites(SSLContext sslContext, SSLServerSocket sslServerSocket, String[] suites) {
    }

    @Override
    public void setEnabledProtocols(SSLContext sslContext, SSLSocket sslSocket, String[] protocols) {
    }

    @Override
    public void setEnabledProtocols(SSLContext sslContext, SSLEngine sslEngine, String[] protocols) {
    }

    @Override
    public void setEnabledProtocols(SSLContext sslContext, SSLServerSocket sslServerSocket, String[] protocols) {
    }

    private SSLParameters redefine(SSLParameters original, String[] supportedCipherSuites, String[] supportedProtocols) {
        SSLParameters params = new SSLParameters();
        this.configure(params, this.protocolSelector.evaluate(supportedProtocols), this.cipherSuiteSelector.evaluate(supportedCipherSuites));
        params.setServerNames(original.getServerNames());
        params.setSNIMatchers(original.getSNIMatchers());
        params.setAlgorithmConstraints(original.getAlgorithmConstraints());
        params.setEndpointIdentificationAlgorithm(original.getEndpointIdentificationAlgorithm());
        return params;
    }

    @Override
    public void setSSLParameters(SSLContext sslContext, SSLSocket sslSocket, SSLParameters parameters) {
        sslSocket.setSSLParameters(this.redefine(parameters, sslSocket.getSupportedCipherSuites(), sslSocket.getSupportedProtocols()));
    }

    @Override
    public void setSSLParameters(SSLContext sslContext, SSLEngine sslEngine, SSLParameters parameters) {
        sslEngine.setSSLParameters(this.redefine(parameters, sslEngine.getSupportedCipherSuites(), sslEngine.getSupportedProtocols()));
    }

    @Override
    public void setSSLParameters(SSLContext sslContext, SSLServerSocket sslServerSocket, SSLParameters parameters) {
        sslServerSocket.setSSLParameters(this.redefine(parameters, sslServerSocket.getSupportedCipherSuites(), sslServerSocket.getSupportedProtocols()));
    }

    @Override
    public void setUseClientMode(SSLContext sslContext, SSLSocket sslSocket, boolean mode) {
    }

    @Override
    public void setUseClientMode(SSLContext sslContext, SSLEngine sslEngine, boolean mode) {
    }

    @Override
    public void setUseClientMode(SSLContext sslContext, SSLServerSocket sslServerSocket, boolean mode) {
    }
}

