/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetCertificateCredentialAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final SecurityFactory<X509CertificateChainPrivateCredential> credentialFactory;

    SetCertificateCredentialAuthenticationConfiguration(AuthenticationConfiguration parent, SecurityFactory<X509CertificateChainPrivateCredential> credentialFactory) {
        super(parent.without(SetPasswordAuthenticationConfiguration.class).without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class));
        this.credentialFactory = credentialFactory;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetCertificateCredentialAuthenticationConfiguration(newParent, this.credentialFactory);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            X509CertificateChainPrivateCredential certChainPrivateCredential;
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            try {
                certChainPrivateCredential = this.credentialFactory.create();
            }
            catch (GeneralSecurityException e) {
                throw ElytronMessages.log.unableToReadCredential(e);
            }
            if (credentialCallback.isCredentialSupported(certChainPrivateCredential.getClass(), certChainPrivateCredential.getPrivateKey().getAlgorithm())) {
                credentialCallback.setCredential(certChainPrivateCredential);
                return;
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        Set<Class<?>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        return types == null || types.contains(X509CertificateChainPrivateCredential.class) || super.filterOneSaslMechanism(mechanismName);
    }
}

