/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialParameterCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetAnonymousAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCertificateCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetGSSCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyManagerCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetKeyStoreCredentialAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetNamePrincipalAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPasswordAuthenticationConfiguration;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetPasswordCallbackHandlerAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final CallbackHandler callbackHandler;

    SetPasswordCallbackHandlerAuthenticationConfiguration(AuthenticationConfiguration parent, CallbackHandler callbackHandler) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class).without(SetNamePrincipalAuthenticationConfiguration.class).without(SetPasswordAuthenticationConfiguration.class).without(SetKeyStoreCredentialAuthenticationConfiguration.class).without(SetAnonymousAuthenticationConfiguration.class).without(SetGSSCredentialAuthenticationConfiguration.class).without(SetKeyManagerCredentialAuthenticationConfiguration.class).without(SetCertificateCredentialAuthenticationConfiguration.class));
        this.callbackHandler = callbackHandler;
    }

    @Override
    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ArrayList<Callback> list = null;
        for (Callback callback : callbacks) {
            if (!(callback instanceof PasswordCallback) && !(callback instanceof CredentialCallback) && !(callback instanceof CredentialParameterCallback)) continue;
            if (list == null) {
                list = new ArrayList<Callback>(callbacks.length);
            }
            list.add(callback);
        }
        if (list != null) {
            this.callbackHandler.handle(list.toArray(new Callback[list.size()]));
        }
        super.handleCallbacks(config, callbacks);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof PasswordCallback || callback instanceof CredentialCallback || callback instanceof CredentialParameterCallback) {
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        Set<Class<?>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        return types == null || types.contains(PasswordCredential.class) || super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetPasswordCallbackHandlerAuthenticationConfiguration(newParent, this.callbackHandler);
    }
}

