/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final KeyStore keyStore;
    public final char USER_CREDENTIAL_DELIMITER = (char)124;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        return new KeyStoreRealmIdentity(name);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(String credentialName) {
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private KeyStore.Entry getEntry(String name) {
        try {
            return this.keyStore.getEntry(name, null);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (UnrecoverableEntryException e) {
            return null;
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final String name;

        private KeyStoreRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name + '|' + credentialName);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            return SupportLevel.SUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(String credentialName, Class<C> credentialType) {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name + '|' + credentialName);
            if (entry == null) {
                return null;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (credentialType.isAssignableFrom(PasswordCredential.class)) {
                    return (C)((Credential)credentialType.cast(new PasswordCredential(password)));
                }
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = privateKeyEntry.getCertificate();
                if (credentialType.isAssignableFrom(X509CertificateChainPublicCredential.class) && certificate instanceof X509Certificate) {
                    return (C)((Credential)credentialType.cast(new X509CertificateChainPublicCredential((X509Certificate)certificate)));
                }
                if (credentialType.isAssignableFrom(X509CertificateChainPrivateCredential.class) && certificate instanceof X509Certificate) {
                    return (C)((Credential)credentialType.cast(new X509CertificateChainPrivateCredential(privateKey, (X509Certificate)certificate)));
                }
                if (credentialType.isAssignableFrom(KeyPairCredential.class)) {
                    return (C)((Credential)credentialType.cast(new KeyPairCredential(new KeyPair(certificate.getPublicKey(), privateKey))));
                }
            } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
                Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
                if (credentialType.isAssignableFrom(X509CertificateChainPublicCredential.class) && certificate instanceof X509Certificate) {
                    return (C)((Credential)credentialType.cast(new X509CertificateChainPublicCredential((X509Certificate)certificate)));
                }
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                if (credentialType.isAssignableFrom(SecretKeyCredential.class)) {
                    return (C)((Credential)credentialType.cast(new SecretKeyCredential(secretKey)));
                }
            }
            return null;
        }

        @Override
        public Credential getCredential(String credentialName) throws RealmUnavailableException {
            return this.getCredential(credentialName, Credential.class);
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            return new AuthorizationIdentity(){};
        }

        @Override
        public boolean verifyEvidence(String credentialName, Evidence evidence) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name + '|' + credentialName);
            if (entry == null) {
                return false;
            }
            if (entry instanceof PasswordEntry) {
                Password password = ((PasswordEntry)entry).getPassword();
                if (evidence instanceof PasswordGuessEvidence) {
                    try {
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                        return passwordFactory.verify(passwordFactory.translate(password), ((PasswordGuessEvidence)evidence).getGuess());
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new RealmUnavailableException(e);
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    }
}

