/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.jdbc;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.jdbc.JdbcSecurityRealmBuilder;
import org.wildfly.security.auth.provider.jdbc.KeyMapper;
import org.wildfly.security.auth.provider.jdbc.QueryConfiguration;
import org.wildfly.security.auth.provider.jdbc.mapper.AttributeMapper;
import org.wildfly.security.auth.provider.jdbc.mapper.PasswordKeyMapper;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;

public class JdbcSecurityRealm
implements SecurityRealm {
    private final List<QueryConfiguration> queryConfiguration;

    public static JdbcSecurityRealmBuilder builder() {
        return new JdbcSecurityRealmBuilder();
    }

    JdbcSecurityRealm(List<QueryConfiguration> queryConfiguration) {
        this.queryConfiguration = queryConfiguration;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) throws RealmUnavailableException {
        return new JdbcRealmIdentity(name);
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
        for (QueryConfiguration configuration : this.queryConfiguration) {
            for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                if (!keyMapper.getCredentialName().equals(credentialName)) continue;
                return SupportLevel.POSSIBLY_SUPPORTED;
            }
        }
        return SupportLevel.UNSUPPORTED;
    }

    private static interface ResultSetCallback<E> {
        public E handle(ResultSet var1) throws SQLException;
    }

    private class JdbcRealmIdentity
    implements RealmIdentity {
        private final String name;
        private JdbcIdentity identity;

        public JdbcRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                    if (!keyMapper.getCredentialName().equals(credentialName)) continue;
                    return this.executePrincipalQuery(configuration, keyMapper::getCredentialSupport);
                }
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public Credential getCredential(String credentialName) throws RealmUnavailableException {
            for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                for (KeyMapper keyMapper : configuration.getColumnMappers(KeyMapper.class)) {
                    if (!keyMapper.getCredentialName().equals(credentialName)) continue;
                    return this.executePrincipalQuery(configuration, resultSet -> keyMapper.map(resultSet));
                }
            }
            return null;
        }

        @Override
        public boolean verifyEvidence(String credentialName, Evidence evidence) throws RealmUnavailableException {
            if (evidence != null) {
                for (QueryConfiguration configuration : JdbcSecurityRealm.this.queryConfiguration) {
                    for (PasswordKeyMapper passwordMapper : configuration.getColumnMappers(PasswordKeyMapper.class)) {
                        if (!passwordMapper.getCredentialName().equals(credentialName)) continue;
                        return this.verifyPassword(configuration, passwordMapper, evidence);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return this.getIdentity() != null;
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        private JdbcIdentity getIdentity() {
            if (this.identity == null) {
                JdbcSecurityRealm.this.queryConfiguration.stream().map(queryConfiguration -> this.executePrincipalQuery((QueryConfiguration)queryConfiguration, resultSet -> {
                    if (resultSet.next()) {
                        MapAttributes attributes = new MapAttributes();
                        do {
                            queryConfiguration.getColumnMappers(AttributeMapper.class).forEach(attributeMapper -> {
                                try {
                                    Object value = attributeMapper.map(resultSet);
                                    if (value != null) {
                                        attributes.addFirst(attributeMapper.getName(), value.toString());
                                    }
                                }
                                catch (SQLException cause) {
                                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(this.name, cause);
                                }
                            });
                        } while (resultSet.next());
                        return attributes;
                    }
                    return null;
                })).collect(Collectors.reducing((lAttribute, rAttribute) -> {
                    MapAttributes attributes = new MapAttributes((Attributes)lAttribute);
                    for (Attributes.Entry rEntry : rAttribute.entries()) {
                        attributes.get(rEntry.getKey()).addAll(rEntry);
                    }
                    return attributes;
                })).ifPresent(attributes -> {
                    this.identity = new JdbcIdentity((Attributes)attributes);
                });
            }
            return this.identity;
        }

        private boolean verifyPassword(QueryConfiguration configuration, PasswordKeyMapper passwordMapper, Evidence evidence) {
            Credential credential = this.executePrincipalQuery(configuration, passwordMapper::map);
            String algorithm = passwordMapper.getAlgorithm();
            try {
                if (credential instanceof PasswordCredential) {
                    PasswordFactory passwordFactory = this.getPasswordFactory(algorithm);
                    if (!(evidence instanceof PasswordGuessEvidence)) {
                        throw ElytronMessages.log.passwordBasedCredentialsMustBeCharsOrClearPassword();
                    }
                    char[] guessCredentialChars = ((PasswordGuessEvidence)evidence).getGuess();
                    return passwordFactory.verify(((PasswordCredential)credential).getPassword(), guessCredentialChars);
                }
            }
            catch (InvalidKeyException e) {
                throw ElytronMessages.log.invalidPasswordKeyForAlgorithm(algorithm, e);
            }
            return false;
        }

        private PasswordFactory getPasswordFactory(String algorithm) {
            try {
                return PasswordFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw ElytronMessages.log.couldNotObtainPasswordFactoryForAlgorithm(algorithm, e);
            }
        }

        private Connection getConnection(QueryConfiguration configuration) {
            try {
                DataSource dataSource = configuration.getDataSource();
                return dataSource.getConnection();
            }
            catch (Exception e) {
                throw ElytronMessages.log.couldNotOpenConnection(e);
            }
        }

        /*
         * Exception decompiling
         */
        private <E> E executePrincipalQuery(QueryConfiguration configuration, ResultSetCallback<E> resultSetCallback) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class JdbcIdentity {
            private final Attributes attributes;

            JdbcIdentity(Attributes attributes) {
                this.attributes = attributes;
            }
        }
    }
}

