/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.CredentialPersister;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.provider.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.provider.ldap.OtpCredentialLoader;
import org.wildfly.security.auth.provider.ldap.UserPasswordCredentialLoader;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;

class LdapSecurityRealm
implements ModifiableSecurityRealm {
    public final String VERIFIABLE_CREDENTIAL_NAME = "ldap-verifiable";
    private final DirContextFactory dirContextFactory;
    private final NameRewriter nameRewriter;
    private final PrincipalMapping principalMapping;
    private final List<CredentialLoader> credentialLoaders = new ArrayList<CredentialLoader>();
    private final List<CredentialPersister> credentialPersisters = new ArrayList<CredentialPersister>();

    LdapSecurityRealm(DirContextFactory dirContextFactory, NameRewriter nameRewriter, PrincipalMapping principalMapping) {
        this.dirContextFactory = dirContextFactory;
        this.nameRewriter = nameRewriter;
        this.principalMapping = principalMapping;
        this.credentialLoaders.add(new UserPasswordCredentialLoader(this.principalMapping.passwordAttribute));
        if (this.principalMapping.otpAlgorithmAttribute != null) {
            OtpCredentialLoader otpCredentialLoader = new OtpCredentialLoader("otp", this.principalMapping.otpAlgorithmAttribute, this.principalMapping.otpHashAttribute, this.principalMapping.otpSeedAttribute, this.principalMapping.otpSequenceAttribute);
            this.credentialLoaders.add(otpCredentialLoader);
            this.credentialPersisters.add(otpCredentialLoader);
        }
    }

    @Override
    public ModifiableRealmIdentity createRealmIdentity(String name) {
        if ((name = this.nameRewriter.rewriteName(name)) == null) {
            throw ElytronMessages.log.invalidName();
        }
        return new LdapRealmIdentity(name);
    }

    @Override
    public Iterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        return null;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(String credentialName) {
        Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (CredentialLoader loader : this.credentialLoaders) {
            SupportLevel support = loader.getCredentialSupport(this.dirContextFactory, credentialName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    static class PrincipalMapping {
        private final String searchDn;
        private final boolean searchRecursive;
        private final String rdnIdentifier;
        private final String passwordAttribute;
        private final String otpAlgorithmAttribute;
        private final String otpHashAttribute;
        private final String otpSeedAttribute;
        private final String otpSequenceAttribute;
        private final List<LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute> attributes;
        public final int searchTimeLimit;

        public PrincipalMapping(String searchDn, boolean searchRecursive, int searchTimeLimit, String rdnIdentifier, String passwordAttribute, String otpAlgorithmAttribute, String otpHashAttribute, String otpSeedAttribute, String otpSequenceAttribute, List<LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute> attributes) {
            Assert.checkNotNullParam((String)"rdnIdentifier", (Object)rdnIdentifier);
            Assert.checkNotNullParam((String)"passwordAttribute", (Object)passwordAttribute);
            this.searchDn = searchDn;
            this.searchRecursive = searchRecursive;
            this.searchTimeLimit = searchTimeLimit;
            this.rdnIdentifier = rdnIdentifier;
            this.passwordAttribute = passwordAttribute;
            this.otpAlgorithmAttribute = otpAlgorithmAttribute;
            this.otpHashAttribute = otpHashAttribute;
            this.otpSeedAttribute = otpSeedAttribute;
            this.otpSequenceAttribute = otpSequenceAttribute;
            this.attributes = attributes;
        }

        static /* synthetic */ String access$1100(PrincipalMapping x0) {
            return x0.rdnIdentifier;
        }
    }

    private class LdapRealmIdentity
    implements ModifiableRealmIdentity {
        private final String name;
        private LdapIdentity identity;

        LdapRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialName) == SupportLevel.UNSUPPORTED) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel support = null;
            for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                if (!loader.getCredentialSupport(LdapSecurityRealm.this.dirContextFactory, credentialName).mayBeSupported()) continue;
                IdentityCredentialLoader icl = loader.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                SupportLevel temp = icl.getCredentialSupport(credentialName);
                if (temp != null && temp.isDefinitelySupported()) {
                    return temp;
                }
                if (support != null && (temp == null || support.compareTo(temp) >= 0)) continue;
                support = temp;
            }
            if (support == null) {
                return SupportLevel.UNSUPPORTED;
            }
            return support;
        }

        @Override
        public Credential getCredential(String credentialName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialName) == SupportLevel.UNSUPPORTED) {
                return null;
            }
            for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                IdentityCredentialLoader icl;
                Credential credential;
                if (!loader.getCredentialSupport(LdapSecurityRealm.this.dirContextFactory, credentialName).mayBeSupported() || (credential = (icl = loader.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName())).getCredential(credentialName, Credential.class)) == null) continue;
                return credential;
            }
            return null;
        }

        private boolean persistCredential(String credentialName, Credential credential) throws RealmUnavailableException {
            for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                IdentityCredentialPersister icp = persister.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                if (!icp.getCredentialPersistSupport(credentialName)) continue;
                icp.persistCredential(credentialName, credential);
                return true;
            }
            return false;
        }

        @Override
        public void setCredential(String credentialName, Credential credential) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            Assert.checkNotNullParam((String)"credential", (Object)credential);
            if (!this.exists()) {
                throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
            }
            if (!this.persistCredential(credentialName, credential)) {
                throw ElytronMessages.log.ldapRealmsPersisterNotSupportCredentialName(credentialName);
            }
        }

        @Override
        public void deleteCredential(String credentialName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            if (!this.exists()) {
                throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
            }
            throw Assert.unsupported();
        }

        @Override
        public void setCredentials(Map<String, Credential> credentials) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentials", credentials);
            if (!this.exists()) {
                throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
            }
            for (CredentialPersister credentialPersister : LdapSecurityRealm.this.credentialPersisters) {
                IdentityCredentialPersister icp = credentialPersister.forIdentity(LdapSecurityRealm.this.dirContextFactory, this.identity.getDistinguishedName());
                icp.clearCredentials();
            }
            for (Map.Entry entry : credentials.entrySet()) {
                if (this.persistCredential((String)entry.getKey(), (Credential)entry.getValue())) continue;
                throw ElytronMessages.log.ldapRealmsPersisterNotSupportCredentialName((String)entry.getKey());
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verifyEvidence(String credentialName, Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialName", (Object)credentialName);
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            if (!"ldap-verifiable".equals(credentialName)) {
                return false;
            }
            if (!this.exists()) {
                return false;
            }
            if (!(evidence instanceof PasswordGuessEvidence)) {
                throw ElytronMessages.log.passwordBasedCredentialsMustBeCharsOrClearPassword();
            }
            char[] password = ((PasswordGuessEvidence)evidence).getGuess();
            DirContext dirContext = null;
            try {
                dirContext = LdapSecurityRealm.this.dirContextFactory.obtainDirContext(callbacks -> {
                    for (Callback callback : callbacks) {
                        Callback nameCallback;
                        if (NameCallback.class.isInstance(callback)) {
                            nameCallback = (NameCallback)callback;
                            ((NameCallback)nameCallback).setName(this.identity.getDistinguishedName());
                            continue;
                        }
                        if (!PasswordCallback.class.isInstance(callback)) continue;
                        nameCallback = (PasswordCallback)callback;
                        ((PasswordCallback)nameCallback).setPassword(password);
                    }
                }, null);
                boolean bl = true;
                LdapSecurityRealm.this.dirContextFactory.returnContext(dirContext);
                return bl;
            }
            catch (NamingException e) {
                try {
                    ElytronMessages.log.debugf("Credential verification failed.", e);
                    LdapSecurityRealm.this.dirContextFactory.returnContext(dirContext);
                }
                catch (Throwable throwable) {
                    LdapSecurityRealm.this.dirContextFactory.returnContext(dirContext);
                    throw throwable;
                }
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            boolean exists;
            if (this.identity == null) {
                this.identity = this.getIdentity(this.name);
            }
            boolean bl = exists = this.identity != null;
            if (!exists) {
                ElytronMessages.log.debugf("Principal [%s] does not exists.", this.name);
            }
            return exists;
        }

        /*
         * Exception decompiling
         */
        private LdapIdentity getIdentity(String principalName) throws RealmUnavailableException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Map<String, Collection<String>> extractFilteredAttributes(SearchResult result, DirContext context) {
            String principalDn = result.getNameInNamespace();
            return this.extractAttributes(attribute -> attribute.getFilter() != null, attribute -> {
                ArrayList values = new ArrayList();
                String searchDn = attribute.getSearchDn();
                if (searchDn == null) {
                    searchDn = LdapSecurityRealm.this.principalMapping.searchDn;
                }
                LdapSearch search = new LdapSearch(searchDn, attribute.getFilter(), principalDn);
                search.setReturningAttributes(attribute.getLdapName());
                try (Stream<SearchResult> searchResult = search.search(context);){
                    searchResult.forEach(entry -> {
                        String valueRdn = attribute.getRdn();
                        if (valueRdn != null) {
                            String entryDn = entry.getNameInNamespace();
                            try {
                                for (Rdn rdn : new LdapName(entryDn).getRdns()) {
                                    if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                                    values.add(rdn.getValue().toString());
                                }
                            }
                            catch (Exception cause) {
                                throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(attribute.getName(), entryDn, valueRdn);
                            }
                        } else {
                            javax.naming.directory.Attributes entryAttributes = entry.getAttributes();
                            Attribute ldapAttribute = entryAttributes.get(attribute.getLdapName());
                            NamingEnumeration<?> attributeValues = null;
                            try {
                                attributeValues = ldapAttribute.getAll();
                                while (attributeValues.hasMore()) {
                                    values.add(attributeValues.next().toString());
                                }
                            }
                            catch (Exception cause) {
                                throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                            }
                            finally {
                                if (attributeValues != null) {
                                    try {
                                        attributeValues.close();
                                    }
                                    catch (NamingException namingException) {}
                                }
                            }
                        }
                    });
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                }
                return values;
            });
        }

        private Map<String, Collection<String>> extractSingleAttributes(SearchResult searchResult) {
            return this.extractAttributes(attribute -> attribute.getFilter() == null, attribute -> {
                javax.naming.directory.Attributes returnedAttributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> attributesEnum = returnedAttributes.getAll();
                ArrayList<String> values = new ArrayList<String>();
                try {
                    NamingEnumeration<?> attributeValues;
                    while (attributesEnum.hasMore()) {
                        Attribute ldapAttribute = attributesEnum.next();
                        if (!ldapAttribute.getID().equalsIgnoreCase(attribute.getLdapName())) continue;
                        attributeValues = ldapAttribute.getAll();
                        while (attributeValues.hasMore()) {
                            String value = attributeValues.next().toString();
                            String valueRdn = attribute.getRdn();
                            if (valueRdn != null) {
                                try {
                                    for (Rdn rdn : new LdapName(value).getRdns()) {
                                        if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                                        value = rdn.getValue().toString();
                                        break;
                                    }
                                }
                                catch (Exception cause) {
                                    throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(attribute.getName(), value, valueRdn);
                                }
                            }
                            values.add(value);
                        }
                        if (attributeValues == null) continue;
                        try {
                            attributeValues.close();
                        }
                        catch (NamingException namingException) {
                        }
                    }
                    return values;
                    {
                        catch (Throwable throwable) {
                            if (attributeValues == null) throw throwable;
                            try {
                                attributeValues.close();
                                throw throwable;
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                catch (NamingException cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(searchResult.getNameInNamespace(), cause);
                }
            });
        }

        private SearchControls createSearchControls(String ... returningAttributes) {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(LdapSecurityRealm.this.principalMapping.searchRecursive ? 2 : 1);
            searchControls.setTimeLimit(((LdapSecurityRealm)LdapSecurityRealm.this).principalMapping.searchTimeLimit);
            searchControls.setReturningAttributes(returningAttributes);
            return searchControls;
        }

        private Map<String, Collection<String>> extractAttributes(Predicate<LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute> filter, Function<LdapSecurityRealmBuilder.PrincipalMappingBuilder.Attribute, Collection<String>> valueFunction) {
            return LdapSecurityRealm.this.principalMapping.attributes.stream().filter(filter).collect(Collectors.toMap(attribute -> attribute.getName(), valueFunction, (m1, m2) -> {
                ArrayList merged = new ArrayList(m1);
                merged.addAll(m2);
                return merged;
            }));
        }

        @Override
        public void delete() throws RealmUnavailableException {
            throw Assert.unsupported();
        }

        @Override
        public void create() throws RealmUnavailableException {
            throw Assert.unsupported();
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            throw Assert.unsupported();
        }

        private static /* synthetic */ void lambda$getIdentity$60(LdapIdentity identity, String key) {
            Attributes.Entry values = identity.attributes.get(key);
            values.forEach(value -> ElytronMessages.log.debugf("    Attribute [%s] value [%s].", key, value));
        }

        private /* synthetic */ LdapIdentity lambda$getIdentity$58(DirContext finalContext, SearchResult result) {
            MapAttributes identityAttributes = new MapAttributes();
            identityAttributes.addAll(this.extractSingleAttributes(result));
            identityAttributes.addAll(this.extractFilteredAttributes(result, finalContext));
            return new LdapIdentity(result.getNameInNamespace(), identityAttributes.asReadOnly());
        }

        private static /* synthetic */ String[] lambda$getIdentity$57(int x$0) {
            return new String[x$0];
        }

        private class LdapSearch {
            private final String[] filterArgs;
            private final String searchDn;
            private final String filter;
            private String[] returningAttributes;

            public LdapSearch(String searchDn, String filter, String ... filterArgs) {
                this.searchDn = searchDn;
                this.filter = filter;
                this.filterArgs = filterArgs;
            }

            public Stream<SearchResult> search(DirContext context) throws RealmUnavailableException {
                ElytronMessages.log.debugf("Executing search [%s] in context [%s] with arguments [%s]. Returning attributes are [%s]", new Object[]{this.filter, this.searchDn, this.filterArgs, this.returningAttributes});
                try {
                    final NamingEnumeration<SearchResult> result = context.search(this.searchDn, this.filter, (Object[])this.filterArgs, LdapRealmIdentity.this.createSearchControls(this.returningAttributes));
                    return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<SearchResult>(Long.MAX_VALUE, 256){

                        @Override
                        public boolean tryAdvance(Consumer<? super SearchResult> action) {
                            try {
                                if (!result.hasMore()) {
                                    return false;
                                }
                                SearchResult entry = (SearchResult)result.next();
                                ElytronMessages.log.debugf("Found entry [%s].", entry.getNameInNamespace());
                                action.accept(entry);
                                return true;
                            }
                            catch (NamingException e) {
                                throw ElytronMessages.log.ldapRealmErrorWhileConsumingResultsFromSearch(LdapSearch.this.searchDn, LdapSearch.this.filter, LdapSearch.this.filterArgs.toString(), e);
                            }
                        }
                    }, false).onClose(() -> {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainIdentityFromServer(cause);
                }
            }

            public void setReturningAttributes(String ... returningAttributes) {
                this.returningAttributes = returningAttributes;
            }
        }

        private class LdapIdentity {
            private final String distinguishedName;
            private final Attributes attributes;

            LdapIdentity(String distinguishedName, Attributes attributes) {
                this.distinguishedName = distinguishedName;
                this.attributes = attributes;
            }

            String getDistinguishedName() {
                return this.distinguishedName;
            }
        }
    }
}

