/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.io.IOException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.CredentialPersister;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.provider.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;

class UserPasswordCredentialLoader
implements CredentialLoader,
CredentialPersister {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    static Map<String, String> CREDENTIAL_TO_ALGORITHM = new HashMap<String, String>();
    private final String userPasswordAttributeName;

    public UserPasswordCredentialLoader(String userPasswordAttributeName) {
        this.userPasswordAttributeName = userPasswordAttributeName;
    }

    @Override
    public SupportLevel getCredentialSupport(DirContextFactory contextFactory, String credentialName) {
        int delimiter = credentialName.lastIndexOf(45);
        if (delimiter <= 0) {
            return SupportLevel.UNSUPPORTED;
        }
        String credentialAttribute = credentialName.substring(0, delimiter);
        String credentialTypeName = credentialName.substring(delimiter + 1);
        if (!credentialAttribute.equals(this.userPasswordAttributeName)) {
            return SupportLevel.UNSUPPORTED;
        }
        return CREDENTIAL_TO_ALGORITHM.containsKey(credentialTypeName) ? SupportLevel.POSSIBLY_SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public ForIdentityLoader forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    static {
        CREDENTIAL_TO_ALGORITHM.put("clear", "clear");
        CREDENTIAL_TO_ALGORITHM.put("md5", "simple-digest-md5");
        CREDENTIAL_TO_ALGORITHM.put("sha1", "simple-digest-sha-1");
        CREDENTIAL_TO_ALGORITHM.put("sha256", "simple-digest-sha-256");
        CREDENTIAL_TO_ALGORITHM.put("sha384", "simple-digest-sha-384");
        CREDENTIAL_TO_ALGORITHM.put("sha512", "simple-digest-sha-512");
        CREDENTIAL_TO_ALGORITHM.put("smd5", "password-salt-digest-md5");
        CREDENTIAL_TO_ALGORITHM.put("ssha", "password-salt-digest-sha-1");
        CREDENTIAL_TO_ALGORITHM.put("ssha256", "password-salt-digest-sha-256");
        CREDENTIAL_TO_ALGORITHM.put("ssha384", "password-salt-digest-sha-384");
        CREDENTIAL_TO_ALGORITHM.put("ssha512", "password-salt-digest-sha-512");
        CREDENTIAL_TO_ALGORITHM.put("crypt_", "bsd-crypt-des");
        CREDENTIAL_TO_ALGORITHM.put("crypt", "crypt-des");
    }

    private class ForIdentityLoader
    implements IdentityCredentialLoader,
    IdentityCredentialPersister {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public SupportLevel getCredentialSupport(String credentialName) {
            Credential credential = this.getCredential(credentialName, Credential.class);
            if (credential != null) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Credential> C getCredential(String credentialName, Class<C> credentialType) {
            DirContext context = null;
            int delimiter = credentialName.lastIndexOf(45);
            if (delimiter <= 0) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("User-password credential name \"" + credentialName + "\" is not in attribute-type form - not supported by LDAP realm");
                }
                return null;
            }
            String credentialAttribute = credentialName.substring(0, delimiter);
            String credentialTypeName = credentialName.substring(delimiter + 1);
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{credentialAttribute});
                Attribute attribute = attributes.get(credentialAttribute);
                for (int i = 0; i < attribute.size(); ++i) {
                    byte[] value = (byte[])attribute.get(i);
                    Password password = UserPasswordPasswordUtil.parseUserPassword(value);
                    String expectedAlgorithm = CREDENTIAL_TO_ALGORITHM.get(credentialTypeName);
                    if (expectedAlgorithm != password.getAlgorithm()) {
                        C c = null;
                        return c;
                    }
                    if (!credentialType.isAssignableFrom(PasswordCredential.class)) continue;
                    Credential credential = (Credential)credentialType.cast(new PasswordCredential(password));
                    return (C)credential;
                }
            }
            catch (InvalidKeySpecException | NamingException e) {
                if (ElytronMessages.log.isTraceEnabled()) {
                    ElytronMessages.log.trace("Getting user-password credential " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            finally {
                this.contextFactory.returnContext(context);
            }
            return null;
        }

        @Override
        public boolean getCredentialPersistSupport(String credentialName) {
            int delimiter = credentialName.lastIndexOf(45);
            if (delimiter <= 0) {
                return false;
            }
            String credentialAttribute = credentialName.substring(0, delimiter);
            String credentialTypeName = credentialName.substring(delimiter + 1);
            if (!credentialAttribute.equals(UserPasswordCredentialLoader.this.userPasswordAttributeName)) {
                return false;
            }
            return CREDENTIAL_TO_ALGORITHM.containsKey(credentialTypeName);
        }

        @Override
        public void persistCredential(String credentialName, Credential credential) throws RealmUnavailableException {
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                byte[] composedPassword = UserPasswordPasswordUtil.composeUserPassword((Password)((Object)credential));
                Assert.assertNotNull((Object)composedPassword);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(UserPasswordCredentialLoader.this.userPasswordAttributeName, composedPassword);
                context.modifyAttributes(this.distinguishedName, 1, (Attributes)attributes);
            }
            catch (IOException | NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), credentialName, this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(UserPasswordCredentialLoader.this.userPasswordAttributeName));
                context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }
    }
}

