/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.X509CertificateChainCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.evidence.X509PeerCertificateEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public interface RealmIdentity {
    public static final RealmIdentity ANONYMOUS = new RealmIdentity(){

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public Credential getCredential(String credentialName) {
            return null;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return true;
        }
    };
    public static final RealmIdentity NON_EXISTENT = new RealmIdentity(){

        @Override
        public SupportLevel getCredentialAcquireSupport(String credentialName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public Credential getCredential(String credentialName) {
            return null;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return false;
        }
    };

    public SupportLevel getCredentialAcquireSupport(String var1) throws RealmUnavailableException;

    public Credential getCredential(String var1) throws RealmUnavailableException;

    default public <C extends Credential> C getCredential(String credentialName, Class<C> credentialType) throws RealmUnavailableException {
        Credential c = this.getCredential((String)Assert.checkNotNullParam((String)"credentialName", (Object)credentialName));
        if (((Class)Assert.checkNotNullParam((String)"credentialType", credentialType)).isInstance(c)) {
            return (C)((Credential)credentialType.cast(c));
        }
        return null;
    }

    default public <C extends Credential> C getCredential(String credentialName, Class<C> credentialType, Set<String> supportedAlgorithms) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"supportedAlgorithms", supportedAlgorithms);
        C c = this.getCredential(credentialName, credentialType);
        if (c != null && (!(c instanceof AlgorithmCredential) || supportedAlgorithms.contains(((AlgorithmCredential)c).getAlgorithm()))) {
            return c;
        }
        return null;
    }

    default public Credential getCredential(List<String> credentialNames, Map<Class<? extends Credential>, Set<String>> supportedTypesWithAlgorithms) throws RealmUnavailableException {
        for (String credentialName : credentialNames) {
            Credential c = this.getCredential(credentialName);
            if (c == null) continue;
            for (Map.Entry<Class<? extends Credential>, Set<String>> currentEntry : supportedTypesWithAlgorithms.entrySet()) {
                if (!currentEntry.getKey().isInstance(c) || c instanceof AlgorithmCredential && !currentEntry.getValue().isEmpty() && !currentEntry.getValue().contains(((AlgorithmCredential)c).getAlgorithm())) continue;
                return c;
            }
        }
        return null;
    }

    default public SupportLevel getEvidenceVerifySupport(String credentialName) throws RealmUnavailableException {
        if (this.getCredentialAcquireSupport(credentialName) != SupportLevel.UNSUPPORTED) {
            return SupportLevel.POSSIBLY_SUPPORTED;
        }
        return SupportLevel.UNSUPPORTED;
    }

    default public boolean verifyEvidence(String credentialName, Evidence evidence) throws RealmUnavailableException {
        if (evidence instanceof PasswordGuessEvidence) {
            char[] passwordGuess = ((PasswordGuessEvidence)evidence).getGuess();
            PasswordCredential credential = this.getCredential(credentialName, PasswordCredential.class);
            if (credential != null) {
                try {
                    Password password = credential.getPassword();
                    PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                    Password translated = passwordFactory.translate(password);
                    return passwordFactory.verify(translated, passwordGuess);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    return false;
                }
            }
        } else if (evidence instanceof X509PeerCertificateEvidence) {
            X509Certificate[] certificateChain;
            X509Certificate certificate = ((X509PeerCertificateEvidence)evidence).getPeerCertificate();
            X509CertificateChainCredential credential = this.getCredential(credentialName, X509CertificateChainCredential.class);
            if (credential != null && (certificateChain = credential.getCertificateChain()).length > 0) {
                return certificateChain[0].equals(certificate);
            }
        }
        return false;
    }

    public boolean exists() throws RealmUnavailableException;

    default public void dispose() {
    }

    default public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
        if (this.exists()) {
            return AuthorizationIdentity.EMPTY;
        }
        throw ElytronMessages.log.userDoesNotExist();
    }
}

