/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.ElytronPermission;

public final class ElytronAuthenticator
extends Authenticator {
    private static final AuthenticationContextConfigurationClient client = AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private static final ElytronPermission CREATE_AUTHENTICATOR_PERMISSION = new ElytronPermission("createAuthenticator");

    public ElytronAuthenticator() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_AUTHENTICATOR_PERMISSION);
        }
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        char[] password;
        NameCallback nameCallback;
        block9: {
            AuthenticationConfiguration authenticationConfiguration;
            AuthenticationContext context = AuthenticationContext.captureCurrent();
            try {
                authenticationConfiguration = client.getAuthenticationConfiguration(this.getRequestingURL().toURI(), context);
            }
            catch (URISyntaxException e) {
                return null;
            }
            if (authenticationConfiguration == null) {
                return null;
            }
            CallbackHandler callbackHandler = client.getCallbackHandler(authenticationConfiguration);
            nameCallback = new NameCallback(this.getRequestingPrompt());
            CredentialCallback credentialCallback = CredentialCallback.builder().addSupportedCredentialType(PasswordCredential.class).build();
            password = null;
            try {
                callbackHandler.handle(new Callback[]{nameCallback, credentialCallback});
                PasswordCredential credential = (PasswordCredential)credentialCallback.getCredential();
                TwoWayPassword twoWayPassword = credential.getPassword(TwoWayPassword.class);
                PasswordFactory factory = PasswordFactory.getInstance(twoWayPassword.getAlgorithm());
                ClearPasswordSpec keySpec = factory.getKeySpec(twoWayPassword, ClearPasswordSpec.class);
                password = keySpec.getEncodedPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (e.getCallback() != credentialCallback) break block9;
                PasswordCallback passwordCallback = new PasswordCallback("Password", false);
                try {
                    callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
                    password = passwordCallback.getPassword();
                }
                catch (IOException | UnsupportedCallbackException e1) {
                    return null;
                }
            }
            catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                return null;
            }
        }
        String name = nameCallback.getName();
        if (name == null || password == null) {
            return null;
        }
        return new PasswordAuthentication(name, password);
    }
}

