/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.cert.X509Certificate;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.X509CertificateChainCredential;

abstract class AbstractX509CertificateChainCredential
implements X509CertificateChainCredential {
    final X509Certificate[] certificateChain;

    AbstractX509CertificateChainCredential(X509Certificate ... certificateChain) {
        Assert.checkNotNullParam((String)"certificateChain", (Object)certificateChain);
        if (certificateChain.length > 0) {
            this.certificateChain = (X509Certificate[])certificateChain.clone();
            int length = this.certificateChain.length;
            for (int i = 0; i < length; ++i) {
                Assert.checkNotNullArrayParam((String)"certificateChain", (int)i, (Object)this.certificateChain[i]);
            }
        } else {
            throw ElytronMessages.log.certificateChainIsEmpty();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.getLastCertificate().getPublicKey().getAlgorithm();
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    @Override
    public X509Certificate getFirstCertificate() {
        return this.certificateChain[0];
    }

    @Override
    public X509Certificate getLastCertificate() {
        return this.certificateChain[this.certificateChain.length - 1];
    }
}

