/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class SecurityProviderServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private static final String SERVICE_TYPE = HttpServerAuthenticationMechanismFactory.class.getSimpleName();
    private final Supplier<Provider[]> providers;

    public SecurityProviderServerMechanismFactory(Supplier<Provider[]> providers) {
        this.providers = (Supplier)Assert.checkNotNullParam((String)"providers", providers);
    }

    public SecurityProviderServerMechanismFactory() {
        this(Security::getProviders);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        LinkedHashSet mechanismNames = new LinkedHashSet();
        for (Provider current : this.providers.get()) {
            Set<Provider.Service> services = current.getServices();
            if (services == null) continue;
            for (Provider.Service currentService : services) {
                if (!SERVICE_TYPE.equals(currentService.getType())) continue;
                try {
                    String[] serviceMechNames = ((HttpServerAuthenticationMechanismFactory)currentService.newInstance(null)).getMechanismNames(properties);
                    Collections.addAll(mechanismNames, serviceMechNames);
                }
                catch (NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug(e);
                }
            }
        }
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) {
        for (Provider current : this.providers.get()) {
            Set<Provider.Service> services = current.getServices();
            if (services == null) continue;
            for (Provider.Service currentService : services) {
                if (!SERVICE_TYPE.equals(currentService.getType())) continue;
                try {
                    HttpServerAuthenticationMechanismFactory factory = (HttpServerAuthenticationMechanismFactory)currentService.newInstance(null);
                    HttpServerAuthenticationMechanism mechanism = factory.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
                    if (mechanism == null) continue;
                    return mechanism;
                }
                catch (NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug(e);
                }
            }
        }
        return null;
    }
}

