/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.auth.callback.VerifyPeerTrustedCallback;
import org.wildfly.security.sasl.entity.TrustedAuthority;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.ssl.SSLUtils;

public final class TrustManagerSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final SecurityFactory<X509TrustManager> trustManagerFactory;

    public TrustManagerSaslServerFactory(SaslServerFactory delegate, X509TrustManager trustManager) {
        super(delegate);
        this.trustManagerFactory = trustManager == null ? SSLUtils.getDefaultX509TrustManagerSecurityFactory() : new FixedSecurityFactory<X509TrustManager>(trustManager);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> iterator = list.iterator();
            while (iterator.hasNext()) {
                X509TrustManager trustManager;
                Callback callback = iterator.next();
                if (callback instanceof TrustedAuthoritiesCallback) {
                    trustManager = this.getTrustManager();
                    ((TrustedAuthoritiesCallback)callback).setTrustedAuthorities(this.getTrustedAuthorities(trustManager.getAcceptedIssuers()));
                    iterator.remove();
                    continue;
                }
                if (!(callback instanceof VerifyPeerTrustedCallback)) continue;
                trustManager = this.getTrustManager();
                VerifyPeerTrustedCallback verifyPeerTrustedCallback = (VerifyPeerTrustedCallback)callback;
                X509Certificate[] certificateChain = verifyPeerTrustedCallback.getCertificateChain();
                String authType = verifyPeerTrustedCallback.getAuthType();
                boolean verified = true;
                try {
                    trustManager.checkClientTrusted(certificateChain, authType);
                }
                catch (CertificateException e) {
                    verified = false;
                }
                verifyPeerTrustedCallback.setVerified(verified);
                iterator.remove();
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }

    private List<TrustedAuthority> getTrustedAuthorities(X509Certificate[] acceptedIssuers) {
        if (acceptedIssuers == null) {
            return null;
        }
        ArrayList<TrustedAuthority> trustedAuthorities = new ArrayList<TrustedAuthority>(acceptedIssuers.length);
        for (X509Certificate acceptedIssuer : acceptedIssuers) {
            trustedAuthorities.add(new TrustedAuthority.CertificateTrustedAuthority(acceptedIssuer));
        }
        return trustedAuthorities;
    }

    private X509TrustManager getTrustManager() throws SaslException {
        try {
            return this.trustManagerFactory.create();
        }
        catch (GeneralSecurityException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }
}

