/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.Principal;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.DERDecoder;
import sun.security.x509.X500Name;

public final class X500PrincipalUtil {
    private static final String[] NO_STRINGS = new String[0];
    private static final boolean HAS_X500_NAME;

    private X500PrincipalUtil() {
    }

    public static String[] getAttributeValues(X500Principal principal, String oid) {
        DERDecoder decoder = new DERDecoder(principal.getEncoded());
        String[] strings = NO_STRINGS;
        int len = 0;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            decoder.startSet();
            while (decoder.hasNextElement()) {
                decoder.startSequence();
                String testOid = decoder.decodeObjectIdentifier();
                if (oid.equals(testOid)) {
                    switch (decoder.peekType()) {
                        case 22: {
                            if (strings.length == len) {
                                strings = Arrays.copyOf(strings, Math.max(2, strings.length) * 2);
                            }
                            strings[len++] = decoder.decodeIA5String();
                            break;
                        }
                        case 19: {
                            if (strings.length == len) {
                                strings = Arrays.copyOf(strings, Math.max(2, strings.length) * 2);
                            }
                            strings[len++] = decoder.decodePrintableString();
                            break;
                        }
                        default: {
                            decoder.skipElement();
                            break;
                        }
                    }
                } else {
                    decoder.skipElement();
                }
                decoder.endSequence();
            }
            decoder.endSet();
        }
        decoder.endSequence();
        if (decoder.hasNextElement()) {
            throw ElytronMessages.log.unexpectedTrailingGarbageInX500principal();
        }
        String[] result = len == 0 ? NO_STRINGS : new String[len];
        for (int i = 0; i < len; ++i) {
            result[len - i - 1] = strings[i];
        }
        return result;
    }

    public static X500Principal asX500Principal(Principal principal) {
        if (principal instanceof X500Principal) {
            return (X500Principal)principal;
        }
        if (HAS_X500_NAME && principal instanceof X500Name) {
            return ((X500Name)principal).asX500Principal();
        }
        return new X500Principal(principal.getName());
    }

    static {
        boolean hasX500Name = false;
        try {
            Class.forName("sun.security.x509.X500Name", true, X500PrincipalUtil.class.getClassLoader());
            hasX500Name = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAS_X500_NAME = hasX500Name;
    }
}

