/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.function.Function;
import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.PeerIdentity;

public abstract class PeerIdentityContext {
    private final ThreadLocal<PeerIdentity> currentIdentity = new ThreadLocal();

    protected PeerIdentityContext() {
    }

    public final PeerIdentity getCurrentIdentity() {
        return this.currentIdentity.get();
    }

    public abstract PeerIdentity authenticate(AuthenticationConfiguration var1) throws AuthenticationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <I> I constructIdentity(Function<PeerIdentity.Configuration, I> constructFunction) {
        PeerIdentity.Configuration conf = new PeerIdentity.Configuration(this);
        try {
            I i = constructFunction.apply(conf);
            return i;
        }
        finally {
            conf.terminate();
        }
    }

    public final boolean owns(PeerIdentity identity) {
        return identity != null && identity.getPeerIdentityContext() == this;
    }

    final PeerIdentity getAndSetPeerIdentity(PeerIdentity newIdentity) {
        assert (newIdentity == null || newIdentity.getPeerIdentityContext() == this);
        try {
            PeerIdentity peerIdentity = this.currentIdentity.get();
            return peerIdentity;
        }
        finally {
            if (newIdentity == null) {
                this.currentIdentity.remove();
            } else {
                this.currentIdentity.set(newIdentity);
            }
        }
    }

    void setPeerIdentity(PeerIdentity newIdentity) {
        assert (newIdentity == null || newIdentity.getPeerIdentityContext() == this);
        if (newIdentity == null) {
            this.currentIdentity.remove();
        } else {
            this.currentIdentity.set(newIdentity);
        }
    }
}

