/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util.sso;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.auth.callback.CachedIdentityAuthorizeCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.cache.IdentityCache;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerRequestWrapper;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.util.sso.SingleSignOnSession;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;

public class SingleSignOnServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory delegate;
    private final SingleSignOnConfiguration configuration;
    private final SingleSignOnSessionFactory singleSignOnSessionFactory;

    public SingleSignOnServerMechanismFactory(HttpServerAuthenticationMechanismFactory delegate, SingleSignOnSessionFactory singleSignOnSessionFactory, SingleSignOnConfiguration configuration) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.singleSignOnSessionFactory = singleSignOnSessionFactory;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        return this.delegate.getMechanismNames(properties);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(final String mechanismName, final Map<String, ?> properties, final CallbackHandler callbackHandler) throws HttpAuthenticationException {
        return new HttpServerAuthenticationMechanism(){

            @Override
            public String getMechanismName() {
                return mechanismName;
            }

            @Override
            public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
                SingleSignOnSession singleSignOnSession = this.getSingleSignOnSession(request);
                if (singleSignOnSession.logout()) {
                    return;
                }
                this.getTargetMechanism(mechanismName, singleSignOnSession).evaluateRequest(this.createHttpServerRequest(request, singleSignOnSession));
            }

            private SingleSignOnSession getSingleSignOnSession(HttpServerRequest request) {
                HttpServerCookie cookie = this.getCookie(request);
                if (cookie == null) {
                    return SingleSignOnServerMechanismFactory.this.singleSignOnSessionFactory.create(request, mechanismName);
                }
                String signOnSessionId = cookie.getValue();
                SingleSignOnSession singleSignOnSession = SingleSignOnServerMechanismFactory.this.singleSignOnSessionFactory.findById(signOnSessionId, request);
                if (singleSignOnSession == null) {
                    return SingleSignOnServerMechanismFactory.this.singleSignOnSessionFactory.create(request, mechanismName);
                }
                return singleSignOnSession;
            }

            private HttpServerAuthenticationMechanism getTargetMechanism(String mechanismName2, IdentityCache identityCache) throws HttpAuthenticationException {
                return SingleSignOnServerMechanismFactory.this.delegate.createAuthenticationMechanism(mechanismName2, properties, SingleSignOnServerMechanismFactory.this.createCallbackHandler(callbackHandler, mechanismName2, identityCache));
            }

            private HttpServerRequest createHttpServerRequest(final HttpServerRequest request, final SingleSignOnSession singleSignOnSession) {
                HttpServerRequestWrapper httpServerRequest = new HttpServerRequestWrapper(request){

                    @Override
                    public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
                        request.noAuthenticationInProgress(response -> {
                            this.clearCookie(request, response, singleSignOnSession);
                            if (responder != null) {
                                responder.sendResponse(response);
                            }
                        });
                    }

                    @Override
                    public void authenticationInProgress(HttpServerMechanismsResponder responder) {
                        request.authenticationInProgress(response -> {
                            this.clearCookie(request, response, singleSignOnSession);
                            if (responder != null) {
                                responder.sendResponse(response);
                            }
                        });
                    }

                    @Override
                    public void authenticationComplete(HttpServerMechanismsResponder responder) {
                        request.authenticationComplete(response -> {
                            HttpServerCookie cookie;
                            String id = singleSignOnSession.getId();
                            if (id != null && (cookie = this.getCookie(request)) == null) {
                                response.setResponseCookie(this.createCookie(id, -1));
                            }
                            if (responder != null) {
                                responder.sendResponse(response);
                            }
                        });
                    }

                    @Override
                    public void authenticationFailed(String message, HttpServerMechanismsResponder responder) {
                        request.authenticationFailed(message, response -> {
                            this.clearCookie(request, response, singleSignOnSession);
                            if (responder != null) {
                                responder.sendResponse(response);
                            }
                        });
                    }
                };
                return httpServerRequest;
            }

            private void clearCookie(HttpServerRequest request, HttpServerResponse response, IdentityCache identityCache) {
                identityCache.remove();
                if (this.getCookie(request) != null) {
                    response.setResponseCookie(this.createCookie(null, 0));
                }
            }

            HttpServerCookie getCookie(HttpServerRequest request) {
                return request.getCookies().stream().filter(current -> SingleSignOnServerMechanismFactory.this.configuration.getCookieName().equals(current.getName())).findFirst().orElse(null);
            }

            HttpServerCookie createCookie(final String value, final int maxAge) {
                return new HttpServerCookie(){

                    @Override
                    public String getName() {
                        return SingleSignOnServerMechanismFactory.this.configuration.getCookieName();
                    }

                    @Override
                    public String getValue() {
                        return value;
                    }

                    @Override
                    public String getDomain() {
                        return SingleSignOnServerMechanismFactory.this.configuration.getDomain();
                    }

                    @Override
                    public int getMaxAge() {
                        return maxAge;
                    }

                    @Override
                    public String getPath() {
                        return SingleSignOnServerMechanismFactory.this.configuration.getPath();
                    }

                    @Override
                    public boolean isSecure() {
                        return SingleSignOnServerMechanismFactory.this.configuration.isSecure();
                    }

                    @Override
                    public int getVersion() {
                        return 0;
                    }

                    @Override
                    public boolean isHttpOnly() {
                        return SingleSignOnServerMechanismFactory.this.configuration.isHttpOnly();
                    }
                };
            }
        };
    }

    private CallbackHandler createCallbackHandler(CallbackHandler callbackHandler, String mechanismName, IdentityCache identityCache) {
        return callbacks -> {
            CachedIdentity cachedIdentity = identityCache.get();
            if (cachedIdentity == null || mechanismName.equals(cachedIdentity.getMechanismName())) {
                for (int i = 0; i < callbacks.length; ++i) {
                    CachedIdentityAuthorizeCallback delegate;
                    Callback current = callbacks[i];
                    if (!(current instanceof CachedIdentityAuthorizeCallback) || (delegate = (CachedIdentityAuthorizeCallback)current).isLocalCache()) continue;
                    Principal principal = delegate.getAuthorizationPrincipal();
                    callbacks[i] = principal != null ? new CachedIdentityAuthorizeCallback(principal, identityCache){

                        @Override
                        public void setAuthorized(SecurityIdentity securityIdentity) {
                            super.setAuthorized(securityIdentity);
                            delegate.setAuthorized(securityIdentity);
                        }
                    } : new CachedIdentityAuthorizeCallback(identityCache, delegate.isLocalCache()){

                        @Override
                        public void setAuthorized(SecurityIdentity securityIdentity) {
                            super.setAuthorized(securityIdentity);
                            delegate.setAuthorized(securityIdentity);
                        }
                    };
                }
            }
            callbackHandler.handle(callbacks);
        };
    }

    public static final class SingleSignOnConfiguration {
        private final String cookieName;
        private final String domain;
        private final String path;
        private final boolean httpOnly;
        private final boolean secure;

        public SingleSignOnConfiguration(String cookieName, String domain, String path, boolean httpOnly, boolean secure) {
            this.cookieName = cookieName;
            this.domain = domain;
            this.path = path;
            this.httpOnly = httpOnly;
            this.secure = secure;
        }

        public String getCookieName() {
            return this.cookieName;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }
    }
}

