/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.common.function.ExceptionUnaryOperator;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ConfigurationKeyManager;
import org.wildfly.security.auth.client.KeyStoreEntrySecurityFactory;
import org.wildfly.security.auth.client.LegacyConfiguration;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.RuleNode;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.ElytronAuthenticator;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.keystore.WrappingPasswordKeyStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.util.ServiceLoaderSupplier;
import org.wildfly.security.x500.X500;

public final class ElytronXmlParser {
    private static final String NS_ELYTRON_1_0 = "urn:elytron:1.0";

    public static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration() throws ConfigXMLParseException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_ELYTRON_1_0));){
                SecurityFactory<AuthenticationContext> securityFactory = ElytronXmlParser.parseAuthenticationClientConfiguration(streamReader);
                return securityFactory;
            }
        }
        return new FixedSecurityFactory<AuthenticationContext>(AuthenticationContext.EMPTY);
    }

    static SecurityFactory<AuthenticationContext> parseAuthenticationClientConfiguration(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    ElytronXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "authentication-client": {
                            SecurityFactory<AuthenticationContext> futureContext = ElytronXmlParser.parseAuthenticationClientType(reader);
                            block15: while (reader.hasNext()) {
                                switch (reader.next()) {
                                    case 3: 
                                    case 5: {
                                        continue block15;
                                    }
                                    case 8: {
                                        return futureContext;
                                    }
                                }
                                if (reader.isWhiteSpace()) continue;
                                throw reader.unexpectedElement();
                            }
                            return futureContext;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
            throw reader.unexpectedContent();
        }
        ServiceLoader<LegacyConfiguration> loader = ServiceLoader.load(LegacyConfiguration.class, ElytronXmlParser.class.getClassLoader());
        Iterator<LegacyConfiguration> iterator = loader.iterator();
        ArrayList<LegacyConfiguration> configs = new ArrayList<LegacyConfiguration>();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    configs.add(iterator.next());
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
        return () -> {
            for (LegacyConfiguration config : configs) {
                AuthenticationContext context = config.getConfiguredAuthenticationContext();
                if (context == null) continue;
                return context;
            }
            return AuthenticationContext.EMPTY;
        };
    }

    static SecurityFactory<AuthenticationContext> parseAuthenticationClientType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        Object futureContext = null;
        ElytronXmlParser.requireNoAttributes(reader);
        SecurityFactory<RuleNode<AuthenticationConfiguration>> authFactory = null;
        SecurityFactory<RuleNode<SecurityFactory<SSLContext>>> sslFactory = null;
        HashMap<String, SecurityFactory<KeyStore>> keyStoresMap = new HashMap<String, SecurityFactory<KeyStore>>();
        HashMap<String, SecurityFactory<SSLContext>> sslContextsMap = new HashMap<String, SecurityFactory<SSLContext>>();
        boolean keyStores = false;
        boolean sslContexts = false;
        boolean netAuthenticator = false;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "rules": {
                        if (authFactory != null) {
                            throw reader.unexpectedElement();
                        }
                        authFactory = ElytronXmlParser.parseAuthenticationClientRulesType(reader, keyStoresMap);
                        break;
                    }
                    case "ssl-context-rules": {
                        if (sslFactory != null) {
                            throw reader.unexpectedElement();
                        }
                        sslFactory = ElytronXmlParser.parseSslContextRulesType(reader, sslContextsMap);
                        break;
                    }
                    case "ssl-contexts": {
                        if (sslContexts) {
                            throw reader.unexpectedElement();
                        }
                        sslContexts = true;
                        ElytronXmlParser.parseSslContextsType(reader, sslContextsMap, keyStoresMap);
                        break;
                    }
                    case "key-stores": {
                        if (keyStores) {
                            throw reader.unexpectedElement();
                        }
                        keyStores = true;
                        ElytronXmlParser.parseKeyStoresType(reader, keyStoresMap);
                        break;
                    }
                    case "net-authenticator": {
                        if (netAuthenticator) {
                            throw reader.unexpectedElement();
                        }
                        netAuthenticator = true;
                        ElytronXmlParser.parseEmptyType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                if (netAuthenticator) {
                    Authenticator.setDefault(new ElytronAuthenticator());
                }
                SecurityFactory<RuleNode<AuthenticationConfiguration>> finalAuthFactory = authFactory;
                SecurityFactory<RuleNode<SecurityFactory<SSLContext>>> finalSslFactory = sslFactory;
                return () -> new AuthenticationContext(finalAuthFactory != null ? (RuleNode)finalAuthFactory.create() : null, finalSslFactory != null ? (RuleNode)finalSslFactory.create() : null);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseSslContextsType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<SSLContext>> sslContextsMap, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw reader.missingRequiredAttribute(null, "name");
        }
        ElytronXmlParser.checkAttributeNamespace(reader, 0);
        if (!reader.getAttributeLocalName(0).equals("name")) {
            throw reader.unexpectedAttribute(0);
        }
        if (count > 1) {
            throw reader.unexpectedAttribute(1);
        }
        String name = reader.getAttributeValue(1);
        if (sslContextsMap.containsKey(name)) {
            throw ElytronMessages.xmlLog.duplicateSslContextName(name, reader);
        }
        int foundBits = 0;
        Supplier<Provider[]> providersSupplier = Security::getProviders;
        String providerName = null;
        CipherSuiteSelector cipherSuiteSelector = null;
        ProtocolSelector protocolSelector = null;
        PrivateKeyKeyStoreEntryCredentialFactory credentialFactory = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "key-store-ssl-certificate": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        credentialFactory = new PrivateKeyKeyStoreEntryCredentialFactory(ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap));
                        break;
                    }
                    case "ssl-cipher-suite": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        cipherSuiteSelector = ElytronXmlParser.parseCipherSuiteSelectorType(reader);
                        break;
                    }
                    case "ssl-protocol": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        protocolSelector = ElytronXmlParser.parseProtocolSelectorNamesType(reader);
                        break;
                    }
                    case "provider-name": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        providerName = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "use-system-providers": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        ElytronXmlParser.parseEmptyType(reader);
                        break;
                    }
                    case "use-module-providers": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        Module module = ElytronXmlParser.parseModuleRefType(reader);
                        providersSupplier = new ServiceLoaderSupplier<Provider>(Provider.class, (ClassLoader)module.getClassLoader());
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag != 2) {
                throw reader.unexpectedContent();
            }
            Supplier<Provider[]> finalProvidersSupplier = providersSupplier;
            ProtocolSelector finalProtocolSelector = protocolSelector;
            CipherSuiteSelector finalCipherSuiteSelector = cipherSuiteSelector;
            String finalProviderName = providerName;
            PrivateKeyKeyStoreEntryCredentialFactory finalCredentialFactory = credentialFactory;
            sslContextsMap.put(name, () -> {
                SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                sslContextBuilder.setClientMode(true);
                if (finalCipherSuiteSelector != null) {
                    sslContextBuilder.setCipherSuiteSelector(finalCipherSuiteSelector);
                }
                if (finalProtocolSelector != null) {
                    sslContextBuilder.setProtocolSelector(finalProtocolSelector);
                }
                if (finalCredentialFactory != null) {
                    ConfigurationKeyManager.Builder builder = new ConfigurationKeyManager.Builder();
                    X509CertificateChainPrivateCredential privateCredential = finalCredentialFactory.create();
                    builder.addCredential(privateCredential);
                    sslContextBuilder.setKeyManager(builder.build());
                }
                sslContextBuilder.setProviderName(finalProviderName);
                sslContextBuilder.setProviderSupplier(finalProvidersSupplier);
                sslContextBuilder.setUseCipherSuitesOrder(true);
                return sslContextBuilder.build().create();
            });
            return;
        }
        throw reader.unexpectedDocumentEnd();
    }

    static SecurityFactory<RuleNode<SecurityFactory<SSLContext>>> parseSslContextRulesType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<SSLContext>> sslContextsMap) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        ArrayList<ExceptionUnaryOperator<RuleNode<SecurityFactory<SSLContext>>, GeneralSecurityException>> rulesList = new ArrayList<ExceptionUnaryOperator<RuleNode<SecurityFactory<SSLContext>>, GeneralSecurityException>>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "rule": {
                        rulesList.add(ElytronXmlParser.parseSslContextRuleType(reader, sslContextsMap));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return new OneTimeSecurityFactory<RuleNode<SecurityFactory<SSLContext>>>(() -> {
                    RuleNode node = null;
                    ListIterator iterator = rulesList.listIterator(rulesList.size());
                    while (iterator.hasPrevious()) {
                        node = (RuleNode)((ExceptionUnaryOperator)iterator.previous()).apply(node);
                    }
                    return node;
                });
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionUnaryOperator<RuleNode<SecurityFactory<SSLContext>>, GeneralSecurityException> parseSslContextRuleType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<SSLContext>> sslContextsMap) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        int tag = reader.nextTag();
        if (tag == 1) {
            MatchRule rule = ElytronXmlParser.parseMatchRuleGroup(reader);
            tag = reader.getEventType();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "use-ssl-context": {
                        String name = ElytronXmlParser.parseNameType(reader);
                        if (!reader.hasNext()) {
                            throw reader.unexpectedDocumentEnd();
                        }
                        if (reader.nextTag() != 2) {
                            throw reader.unexpectedElement();
                        }
                        return next -> {
                            SecurityFactory factory = (SecurityFactory)sslContextsMap.get(name);
                            if (factory == null) {
                                throw ElytronMessages.xmlLog.unknownSslContextSpecified();
                            }
                            return new RuleNode<SecurityFactory>((RuleNode<SecurityFactory>)next, rule, factory);
                        };
                    }
                    case "use-default-ssl-context": {
                        ElytronXmlParser.parseEmptyType(reader);
                        if (!reader.hasNext()) {
                            throw reader.unexpectedDocumentEnd();
                        }
                        if (reader.nextTag() != 2) {
                            throw reader.unexpectedElement();
                        }
                        return next -> new RuleNode<SecurityFactory<SSLContext>>((RuleNode<SecurityFactory<SSLContext>>)next, rule, SSLContext::getDefault);
                    }
                }
                throw reader.unexpectedElement();
            }
        }
        throw reader.missingRequiredElement(NS_ELYTRON_1_0, "use-ssl-context/use-default-ssl-context");
    }

    static SecurityFactory<RuleNode<AuthenticationConfiguration>> parseAuthenticationClientRulesType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        ArrayList<ExceptionUnaryOperator<RuleNode<AuthenticationConfiguration>, GeneralSecurityException>> rulesList = new ArrayList<ExceptionUnaryOperator<RuleNode<AuthenticationConfiguration>, GeneralSecurityException>>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "rule": {
                        rulesList.add(ElytronXmlParser.parseAuthenticationClientRuleType(reader, keyStoresMap));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return new OneTimeSecurityFactory<RuleNode<AuthenticationConfiguration>>(() -> {
                    RuleNode node = null;
                    ListIterator iterator = rulesList.listIterator(rulesList.size());
                    while (iterator.hasPrevious()) {
                        node = (RuleNode)((ExceptionUnaryOperator)iterator.previous()).apply(node);
                    }
                    return node;
                });
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ExceptionUnaryOperator<RuleNode<AuthenticationConfiguration>, GeneralSecurityException> parseAuthenticationClientRuleType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        ExceptionUnaryOperator configuration = ignored -> AuthenticationConfiguration.EMPTY;
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        MatchRule rule = ElytronXmlParser.parseMatchRuleGroup(reader);
        int foundBits = 0;
        int tag = reader.getEventType();
        while (true) {
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "set-host": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        String hostName = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useHost(hostName));
                        break;
                    }
                    case "set-port": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        int port = ElytronXmlParser.parsePortType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.usePort(port));
                        break;
                    }
                    case "set-user-name": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        String userName = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useName(userName));
                        break;
                    }
                    case "set-anonymous": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        ElytronXmlParser.parseEmptyType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, AuthenticationConfiguration::useAnonymous);
                        break;
                    }
                    case "set-mechanism-realm": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        String realm = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useRealm(realm));
                        break;
                    }
                    case "rewrite-user-name-regex": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        NameRewriter nameRewriter = ElytronXmlParser.parseRegexSubstitutionType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.rewriteUser(nameRewriter));
                        break;
                    }
                    case "set-mechanism-properties": {
                        if (ElytronXmlParser.isSet(foundBits, 5)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 5);
                        Map<String, String> mechanismProperties = ElytronXmlParser.parsePropertiesType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useMechanismProperties(mechanismProperties));
                        break;
                    }
                    case "allow-all-sasl-mechanisms": {
                        if (ElytronXmlParser.isSet(foundBits, 6)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 6);
                        ElytronXmlParser.parseEmptyType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, AuthenticationConfiguration::allowAllSaslMechanisms);
                        break;
                    }
                    case "allow-sasl-mechanisms": {
                        if (ElytronXmlParser.isSet(foundBits, 7)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 7);
                        String[] names = ElytronXmlParser.parseNamesType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.allowSaslMechanisms(names));
                        break;
                    }
                    case "forbid-sasl-mechanisms": {
                        if (ElytronXmlParser.isSet(foundBits, 8)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 8);
                        String[] names = ElytronXmlParser.parseNamesType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.forbidSaslMechanisms(names));
                        break;
                    }
                    case "key-store-credential": {
                        if (ElytronXmlParser.isSet(foundBits, 9)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 9);
                        SecurityFactory<KeyStore.Entry> factory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useKeyStoreCredential((KeyStore.Entry)factory.create()));
                        break;
                    }
                    case "clear-password": {
                        if (ElytronXmlParser.isSet(foundBits, 10)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 10);
                        char[] password = ElytronXmlParser.parseClearPassword(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.usePassword(password));
                        break;
                    }
                    case "set-authorization-name": {
                        if (ElytronXmlParser.isSet(foundBits, 11)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 11);
                        String authName = ElytronXmlParser.parseNameType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useAuthorizationName(authName));
                        break;
                    }
                    case "use-system-providers": {
                        if (ElytronXmlParser.isSet(foundBits, 12)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 12);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useProviders(Security::getProviders));
                        break;
                    }
                    case "use-module-providers": {
                        if (ElytronXmlParser.isSet(foundBits, 12)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 12);
                        Module module = ElytronXmlParser.parseModuleRefType(reader);
                        configuration = ElytronXmlParser.andThenOp(configuration, parentConfig -> parentConfig.useProviders(new ServiceLoaderSupplier<Provider>(Provider.class, (ClassLoader)module.getClassLoader())));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
            } else {
                if (tag == 2) {
                    ExceptionUnaryOperator finalConfiguration = configuration;
                    return arg_0 -> ElytronXmlParser.lambda$parseAuthenticationClientRuleType$21(rule, (ExceptionUnaryOperator)finalConfiguration, arg_0);
                }
                throw reader.unexpectedContent();
            }
            if (!reader.hasNext()) {
                throw reader.unexpectedDocumentEnd();
            }
            tag = reader.nextTag();
        }
    }

    static MatchRule parseMatchRuleGroup(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        MatchRule rule = MatchRule.ALL;
        int foundBits = 0;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "match-no-userinfo": {
                        if (ElytronXmlParser.isSet(foundBits, 0)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 0);
                        ElytronXmlParser.parseEmptyType(reader);
                        rule = rule.matchNoUser();
                        break;
                    }
                    case "match-userinfo": {
                        if (ElytronXmlParser.isSet(foundBits, 1)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 1);
                        rule = rule.matchUser(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-protocol": {
                        if (ElytronXmlParser.isSet(foundBits, 2)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 2);
                        rule = rule.matchProtocol(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-host": {
                        if (ElytronXmlParser.isSet(foundBits, 3)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 3);
                        rule = rule.matchHost(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-path": {
                        if (ElytronXmlParser.isSet(foundBits, 4)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 4);
                        rule = rule.matchPath(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-port": {
                        if (ElytronXmlParser.isSet(foundBits, 5)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 5);
                        rule = rule.matchPort(ElytronXmlParser.parsePortType(reader));
                        break;
                    }
                    case "match-urn": {
                        if (ElytronXmlParser.isSet(foundBits, 6)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 6);
                        rule = rule.matchUrnName(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-domain": {
                        if (ElytronXmlParser.isSet(foundBits, 7)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 7);
                        rule = rule.matchLocalSecurityDomain(ElytronXmlParser.parseNameType(reader));
                        break;
                    }
                    case "match-abstract-type": {
                        if (ElytronXmlParser.isSet(foundBits, 8)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 8);
                        rule = ElytronXmlParser.parseMatchAbstractType(rule, reader);
                        break;
                    }
                    case "match-purpose": {
                        if (ElytronXmlParser.isSet(foundBits, 9)) {
                            throw reader.unexpectedElement();
                        }
                        foundBits = ElytronXmlParser.setBit(foundBits, 9);
                        rule = rule.matchPurposes(ElytronXmlParser.parseNamesType(reader));
                        break;
                    }
                    default: {
                        return rule;
                    }
                }
                continue;
            }
            return rule;
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static MatchRule parseMatchAbstractType(MatchRule rule, ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String authority = null;
        block8: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block8;
                }
                case "authority": {
                    authority = reader.getAttributeValue(i);
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        return name == null && authority == null ? rule : rule.matchAbstractType(name, authority);
    }

    private static boolean isSet(int var, int bit) {
        return (var & 1 << bit) != 0;
    }

    private static int setBit(int var, int bit) {
        return var | 1 << bit;
    }

    private static <T> UnaryOperator<T> andThenOp(UnaryOperator<T> first, UnaryOperator<T> second) {
        return t -> second.apply(first.apply(t));
    }

    private static <T, E extends Exception> ExceptionUnaryOperator<T, E> andThenOp(ExceptionUnaryOperator<T, E> first, ExceptionUnaryOperator<T, E> second) {
        return t -> second.apply(first.apply(t));
    }

    static void parseKeyStoresType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "key-store": {
                        ElytronXmlParser.parseKeyStoreType(reader, keyStoresMap);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static void parseKeyStoreType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String type = null;
        String provider = null;
        Boolean wrap = null;
        block26: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "type": {
                    if (type != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    type = reader.getAttributeValue(i);
                    continue block26;
                }
                case "provider": {
                    if (provider != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    provider = reader.getAttributeValue(i);
                    continue block26;
                }
                case "name": {
                    if (name != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    name = reader.getAttributeValue(i);
                    continue block26;
                }
                case "wrap-passwords": {
                    if (wrap != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    wrap = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block26;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (type == null) {
            throw ElytronXmlParser.missingAttribute(reader, "type");
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        SecurityFactory<char[]> passwordFactory = null;
        boolean gotSource = false;
        boolean gotCredential = false;
        String fileSource = null;
        String resourceSource = null;
        URI uriSource = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (!gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        SecurityFactory<KeyStore.Entry> entryFactory = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        passwordFactory = new OneTimeSecurityFactory<char[]>(() -> {
                            KeyStore.Entry entry = (KeyStore.Entry)entryFactory.create();
                            if (entry instanceof PasswordEntry) {
                                Password password = ((PasswordEntry)entry).getPassword();
                                PasswordFactory passwordFactory1 = PasswordFactory.getInstance(password.getAlgorithm());
                                ClearPasswordSpec passwordSpec = passwordFactory1.getKeySpec(password, ClearPasswordSpec.class);
                                return passwordSpec.getEncodedPassword();
                            }
                            return null;
                        });
                        break;
                    }
                    case "key-store-clear-password": {
                        if (!gotSource || gotCredential) {
                            throw reader.unexpectedElement();
                        }
                        gotCredential = true;
                        passwordFactory = new FixedSecurityFactory<char[]>(ElytronXmlParser.parseClearPassword(reader));
                        break;
                    }
                    case "file": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        fileSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "resource": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        resourceSource = ElytronXmlParser.parseNameType(reader);
                        break;
                    }
                    case "uri": {
                        if (gotSource) {
                            throw reader.unexpectedElement();
                        }
                        gotSource = true;
                        uriSource = ElytronXmlParser.parseUriType(reader);
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                SecurityFactory<KeyStore> keyStoreFactory = new KeyStoreCreateFactory(provider, type);
                if (wrap == Boolean.TRUE) {
                    keyStoreFactory = new PasswordKeyStoreFactory(keyStoreFactory);
                }
                if (fileSource != null) {
                    keyStoreFactory = new FileLoadingKeyStoreFactory(keyStoreFactory, passwordFactory, fileSource);
                } else if (resourceSource != null) {
                    keyStoreFactory = new ResourceLoadingKeyStoreFactory(keyStoreFactory, passwordFactory, resourceSource);
                } else if (uriSource != null) {
                    keyStoreFactory = new URILoadingKeyStoreFactory(keyStoreFactory, passwordFactory, uriSource);
                } else {
                    throw new IllegalStateException();
                }
                keyStoresMap.put(name, new OneTimeSecurityFactory<KeyStore>(keyStoreFactory));
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static SecurityFactory<KeyStore.Entry> parseKeyStoreRefType(ConfigurationXMLStreamReader reader, Map<String, SecurityFactory<KeyStore>> keyStoresMap) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String keyStoreName = null;
        String alias = null;
        block16: for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "key-store-name": {
                    if (keyStoreName != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    keyStoreName = reader.getAttributeValue(i);
                    continue block16;
                }
                case "alias": {
                    if (alias != null) {
                        throw reader.unexpectedAttribute(i);
                    }
                    alias = reader.getAttributeValue(i);
                    continue block16;
                }
            }
        }
        if (keyStoreName == null) {
            throw ElytronXmlParser.missingAttribute(reader, "key-store-name");
        }
        if (alias == null) {
            throw ElytronXmlParser.missingAttribute(reader, "alias");
        }
        SecurityFactory<KeyStore.Entry> keyStoreCredential = null;
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "key-store-credential": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        keyStoreCredential = ElytronXmlParser.parseKeyStoreRefType(reader, keyStoresMap);
                        break;
                    }
                    case "key-store-clear-password": {
                        if (keyStoreCredential != null) {
                            throw reader.unexpectedElement();
                        }
                        keyStoreCredential = new FixedSecurityFactory<PasswordEntry>(new PasswordEntry(ClearPassword.createRaw("clear", ElytronXmlParser.parseClearPassword(reader))));
                        break;
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                SecurityFactory<KeyStore.Entry> finalKeyStoreCredential = keyStoreCredential;
                String finalKeyStoreName = keyStoreName;
                return new KeyStoreEntrySecurityFactory(() -> {
                    SecurityFactory keyStoreSecurityFactory = (SecurityFactory)keyStoresMap.get(finalKeyStoreName);
                    if (keyStoreSecurityFactory == null) {
                        throw ElytronMessages.xmlLog.unknownKeyStoreSpecified();
                    }
                    return (KeyStore)keyStoreSecurityFactory.create();
                }, alias, keyStoreCredential == null ? null : () -> {
                    KeyStore.Entry entry = (KeyStore.Entry)finalKeyStoreCredential.create();
                    if (entry instanceof PasswordEntry) {
                        Password password = ((PasswordEntry)entry).getPassword();
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                        ClearPasswordSpec spec = passwordFactory.getKeySpec(password, ClearPasswordSpec.class);
                        return new KeyStore.PasswordProtection(spec.getEncodedPassword());
                    }
                    if (entry instanceof KeyStore.SecretKeyEntry) {
                        SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                        SecretKeyFactory instance = SecretKeyFactory.getInstance(secretKey.getAlgorithm());
                        SecretKeySpec keySpec = (SecretKeySpec)instance.getKeySpec(secretKey, SecretKeySpec.class);
                        byte[] encoded = keySpec.getEncoded();
                        return encoded == null ? null : new KeyStore.PasswordProtection(new String(encoded, StandardCharsets.UTF_8).toCharArray());
                    }
                    return null;
                });
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static void parseEmptyType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ElytronXmlParser.requireNoAttributes(reader);
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static String parseNameType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        return ElytronXmlParser.parseNameType(reader, false);
    }

    static String parseNameType(ConfigurationXMLStreamReader reader, boolean optional) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("name")) {
                throw reader.unexpectedAttribute(i);
            }
            name = reader.getAttributeValue(i);
        }
        if (name == null && !optional) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return name;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static int parsePortType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        int number = -1;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("number")) {
                String s = reader.getAttributeValue(i);
                try {
                    number = Integer.parseInt(s);
                }
                catch (NumberFormatException ignored) {
                    throw ElytronXmlParser.invalidPortNumber(reader, i);
                }
                if (number >= 1 && number <= 65535) continue;
                throw ElytronXmlParser.invalidPortNumber(reader, i);
            }
            throw reader.unexpectedAttribute(i);
        }
        if (number == -1) {
            throw ElytronXmlParser.missingAttribute(reader, "number");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return number;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static NameRewriter parseRegexSubstitutionType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        Pattern pattern = null;
        String replacement = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("pattern")) {
                pattern = Pattern.compile(reader.getAttributeValue(i));
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("replacement")) {
                replacement = reader.getAttributeValue(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (pattern == null) {
            throw ElytronXmlParser.missingAttribute(reader, "pattern");
        }
        if (replacement == null) {
            throw ElytronXmlParser.missingAttribute(reader, "replacement");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return new RegexNameRewriter(pattern, replacement, true);
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static String[] parseNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String[] names = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("names")) {
                throw reader.unexpectedAttribute(i);
            }
            String s = reader.getAttributeValue(i);
            names = s.trim().split("\\s+");
        }
        if (names == null) {
            throw ElytronXmlParser.missingAttribute(reader, "names");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return names;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static URI parseUriType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        URI uri = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("uri")) {
                throw reader.unexpectedAttribute(i);
            }
            uri = reader.getURIAttributeValue(i);
        }
        if (uri == null) {
            throw ElytronXmlParser.missingAttribute(reader, "uri");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return uri;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static CipherSuiteSelector parseCipherSuiteSelectorType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        CipherSuiteSelector selector = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("selector")) {
                throw reader.unexpectedAttribute(i);
            }
            selector = CipherSuiteSelector.fromString(reader.getAttributeValue(i));
        }
        if (selector == null) {
            throw ElytronXmlParser.missingAttribute(reader, "selector");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return selector;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static ProtocolSelector parseProtocolSelectorNamesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        ProtocolSelector selector = ProtocolSelector.empty();
        for (String name : ElytronXmlParser.parseNamesType(reader)) {
            selector = selector.add(name);
        }
        return selector;
    }

    static Module parseModuleRefType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String slot = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (reader.getAttributeLocalName(i).equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (reader.getAttributeLocalName(i).equals("slot")) {
                slot = reader.getAttributeValue(i);
                continue;
            }
            throw reader.unexpectedAttribute(i);
        }
        if (name == null) {
            throw ElytronXmlParser.missingAttribute(reader, "name");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                ModuleIdentifier identifier = ModuleIdentifier.create((String)name, slot);
                try {
                    return Module.getModuleFromCallerModuleLoader((ModuleIdentifier)identifier);
                }
                catch (ModuleLoadException e) {
                    throw ElytronMessages.xmlLog.noModuleFound((XMLStreamReader)reader, e, identifier);
                }
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static char[] parseClearPassword(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        char[] password = null;
        for (int i = 0; i < attributeCount; ++i) {
            ElytronXmlParser.checkAttributeNamespace(reader, i);
            if (!reader.getAttributeLocalName(i).equals("password")) {
                throw reader.unexpectedAttribute(i);
            }
            password = reader.getAttributeValue(i).toCharArray();
        }
        if (password == null) {
            throw ElytronXmlParser.missingAttribute(reader, "password");
        }
        if (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                throw reader.unexpectedElement();
            }
            if (tag == 2) {
                return password;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    static Map<String, String> parsePropertiesType(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (reader.getAttributeCount() > 0) {
            throw reader.unexpectedAttribute(0);
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        while (reader.hasNext()) {
            int tag = reader.nextTag();
            if (tag == 1) {
                ElytronXmlParser.checkElementNamespace(reader);
                switch (reader.getLocalName()) {
                    case "property": {
                        int attributeCount = reader.getAttributeCount();
                        String key = null;
                        String value = null;
                        block15: for (int i = 0; i < attributeCount; ++i) {
                            ElytronXmlParser.checkAttributeNamespace(reader, i);
                            switch (reader.getAttributeLocalName(i)) {
                                case "key": {
                                    if (key != null) {
                                        throw reader.unexpectedAttribute(i);
                                    }
                                    key = reader.getAttributeValue(i);
                                    continue block15;
                                }
                                case "value": {
                                    if (value != null) {
                                        throw reader.unexpectedAttribute(i);
                                    }
                                    value = reader.getAttributeValue(i);
                                    continue block15;
                                }
                                default: {
                                    throw reader.unexpectedAttribute(i);
                                }
                            }
                        }
                        if (key == null) {
                            throw ElytronXmlParser.missingAttribute(reader, "key");
                        }
                        if (value == null) {
                            throw ElytronXmlParser.missingAttribute(reader, "value");
                        }
                        propertiesMap.put(key, value);
                        if (reader.hasNext()) {
                            int innerTag = reader.nextTag();
                            if (innerTag == 1) {
                                throw reader.unexpectedElement();
                            }
                            if (innerTag == 2) break;
                            throw reader.unexpectedContent();
                        }
                        throw reader.unexpectedDocumentEnd();
                    }
                    default: {
                        throw reader.unexpectedElement();
                    }
                }
                continue;
            }
            if (tag == 2) {
                return propertiesMap;
            }
            throw reader.unexpectedContent();
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void checkElementNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (!reader.getNamespaceURI().equals(NS_ELYTRON_1_0)) {
            throw reader.unexpectedElement();
        }
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int idx) throws ConfigXMLParseException {
        String attributeNamespace = reader.getAttributeNamespace(idx);
        if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
            throw reader.unexpectedAttribute(idx);
        }
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
    }

    private static ConfigXMLParseException missingAttribute(ConfigurationXMLStreamReader reader, String name) {
        return reader.missingRequiredAttribute(null, name);
    }

    private static ConfigXMLParseException invalidPortNumber(ConfigurationXMLStreamReader reader, int index) {
        return ElytronMessages.xmlLog.xmlInvalidPortNumber((XMLStreamReader)reader, reader.getAttributeValue(index), reader.getAttributeLocalName(index), reader.getName());
    }

    private static /* synthetic */ RuleNode lambda$parseAuthenticationClientRuleType$21(MatchRule rule, ExceptionUnaryOperator finalConfiguration, RuleNode next) throws GeneralSecurityException {
        return new RuleNode<Object>(next, rule, finalConfiguration.apply((Object)AuthenticationConfiguration.EMPTY));
    }

    static final class PrivateKeyKeyStoreEntryCredentialFactory
    implements SecurityFactory<X509CertificateChainPrivateCredential> {
        private final SecurityFactory<KeyStore.Entry> entrySecurityFactory;

        PrivateKeyKeyStoreEntryCredentialFactory(SecurityFactory<KeyStore.Entry> entrySecurityFactory) {
            this.entrySecurityFactory = entrySecurityFactory;
        }

        @Override
        public X509CertificateChainPrivateCredential create() throws GeneralSecurityException {
            KeyStore.Entry entry = this.entrySecurityFactory.create();
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                X509Certificate[] certificateChain = X500.asX509CertificateArray(privateKeyEntry.getCertificateChain());
                return new X509CertificateChainPrivateCredential(privateKeyEntry.getPrivateKey(), certificateChain);
            }
            throw ElytronMessages.xmlLog.invalidKeyStoreEntryType("unknown", KeyStore.PrivateKeyEntry.class, entry.getClass());
        }
    }

    static final class URILoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final URI uri;

        URILoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory, URI uri) {
            super(delegateFactory, passwordFactory);
            this.uri = uri;
        }

        @Override
        InputStream createStream() throws IOException {
            return this.uri.toURL().openStream();
        }
    }

    static final class ResourceLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final String resourceName;

        ResourceLoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory, String resourceName) {
            super(delegateFactory, passwordFactory);
            this.resourceName = resourceName;
        }

        @Override
        InputStream createStream() throws IOException {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            InputStream stream = contextClassLoader.getResourceAsStream(this.resourceName);
            if (stream == null) {
                throw new FileNotFoundException(this.resourceName);
            }
            return stream;
        }
    }

    static final class FileLoadingKeyStoreFactory
    extends AbstractLoadingKeyStoreFactory {
        private final String fileName;

        FileLoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory, String fileName) {
            super(delegateFactory, passwordFactory);
            this.fileName = fileName;
        }

        @Override
        InputStream createStream() throws FileNotFoundException {
            return new FileInputStream(this.fileName);
        }
    }

    static abstract class AbstractLoadingKeyStoreFactory
    implements SecurityFactory<KeyStore> {
        protected final SecurityFactory<KeyStore> delegateFactory;
        protected final SecurityFactory<char[]> passwordFactory;

        protected AbstractLoadingKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory, SecurityFactory<char[]> passwordFactory) {
            this.delegateFactory = delegateFactory;
            this.passwordFactory = passwordFactory;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            KeyStore keyStore = this.delegateFactory.create();
            try (InputStream fis = this.createStream();){
                keyStore.load(fis, this.passwordFactory == null ? null : this.passwordFactory.create());
            }
            catch (IOException e) {
                throw ElytronMessages.xmlLog.failedToLoadKeyStoreData(e);
            }
            return keyStore;
        }

        abstract InputStream createStream() throws IOException;
    }

    static final class PasswordKeyStoreFactory
    implements SecurityFactory<KeyStore> {
        private final SecurityFactory<KeyStore> delegateFactory;

        PasswordKeyStoreFactory(SecurityFactory<KeyStore> delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            return new WrappingPasswordKeyStore(this.delegateFactory.create());
        }
    }

    static final class KeyStoreCreateFactory
    implements SecurityFactory<KeyStore> {
        private final String provider;
        private final String type;

        KeyStoreCreateFactory(String provider, String type) {
            this.provider = provider;
            this.type = type;
        }

        @Override
        public KeyStore create() throws GeneralSecurityException {
            return this.provider == null ? KeyStore.getInstance(this.type) : KeyStore.getInstance(this.type, this.provider);
        }
    }
}

