/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.function.UnaryOperator;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.wildfly.common.Assert;
import org.wildfly.security.key.RawDHPrivateKey;
import org.wildfly.security.key.RawDSAPrivateKey;
import org.wildfly.security.key.RawECPrivateKey;
import org.wildfly.security.key.RawPBEKey;
import org.wildfly.security.key.RawRSAMultiPrimePrivateCrtKey;
import org.wildfly.security.key.RawRSAPrivateKey;

public final class KeyUtil {
    private static final KeyClonerCreator CLONER_CREATOR = new KeyClonerCreator();

    private KeyUtil() {
    }

    public static <T extends Key> T cloneKey(Class<T> expectType, T key) {
        Assert.checkNotNullParam((String)"expectType", expectType);
        if (key instanceof Destroyable) {
            if (((Destroyable)((Object)key)).isDestroyed()) {
                return (T)((Key)expectType.cast(key));
            }
            return (T)((Key)expectType.cast(((UnaryOperator)CLONER_CREATOR.get(key.getClass())).apply(key)));
        }
        return (T)((Key)expectType.cast(key));
    }

    private static class KeyClonerCreator
    extends ClassValue<UnaryOperator<Key>> {
        private KeyClonerCreator() {
        }

        @Override
        protected UnaryOperator<Key> computeValue(Class<?> type) {
            Method method;
            try {
                method = type.getMethod("destroy", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return UnaryOperator.identity();
            }
            if (method.getDeclaringClass() == Destroyable.class) {
                return UnaryOperator.identity();
            }
            UnaryOperator<Key> op = this.checkForCloneMethod(type, type);
            if (op != null) {
                return op;
            }
            op = this.checkForCopyCtor(type, type);
            if (op != null) {
                return op;
            }
            if (PrivateKey.class.isAssignableFrom(type)) {
                if (DSAPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, DSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, DSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawDSAPrivateKey::new;
                }
                if (ECPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, ECPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, ECPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawECPrivateKey::new;
                }
                if (RSAMultiPrimePrivateCrtKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, RSAMultiPrimePrivateCrtKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, RSAMultiPrimePrivateCrtKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawRSAMultiPrimePrivateCrtKey::new;
                }
                if (RSAPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, RSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, RSAPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawRSAPrivateKey::new;
                }
                if (DHPrivateKey.class.isAssignableFrom(type)) {
                    op = this.checkForCloneMethod(type, DHPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, DHPrivateKey.class);
                    if (op != null) {
                        return op;
                    }
                    return RawDHPrivateKey::new;
                }
                op = this.checkForCloneMethod(type, PrivateKey.class);
                if (op != null) {
                    return op;
                }
                op = this.checkForCopyCtor(type, PrivateKey.class);
                if (op != null) {
                    return op;
                }
            } else {
                if (SecretKey.class.isAssignableFrom(type)) {
                    if (PBEKey.class.isAssignableFrom(type)) {
                        op = this.checkForCloneMethod(type, PBEKey.class);
                        if (op != null) {
                            return op;
                        }
                        op = this.checkForCopyCtor(type, PBEKey.class);
                        if (op != null) {
                            return op;
                        }
                        return RawPBEKey::new;
                    }
                    op = this.checkForCloneMethod(type, SecretKey.class);
                    if (op != null) {
                        return op;
                    }
                    op = this.checkForCopyCtor(type, SecretKey.class);
                    if (op != null) {
                        return op;
                    }
                    return orig -> new SecretKeySpec(orig.getEncoded(), orig.getAlgorithm());
                }
                op = this.checkForCloneMethod(type, Key.class);
                if (op != null) {
                    return op;
                }
            }
            return orig -> {
                throw Assert.unsupported();
            };
        }

        private UnaryOperator<Key> checkForCloneMethod(Class<?> declType, Class<?> returnType) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handle = AccessController.doPrivileged(() -> {
                try {
                    return lookup.findVirtual(declType, "clone", MethodType.methodType(returnType));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    return null;
                }
            });
            return handle == null ? null : KeyClonerCreator.produceOp(handle);
        }

        private UnaryOperator<Key> checkForCopyCtor(Class<?> declType, Class<?> paramType) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle handle = AccessController.doPrivileged(() -> {
                try {
                    return lookup.findConstructor(declType, MethodType.methodType(Void.TYPE, paramType));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    return null;
                }
            });
            return handle == null ? null : KeyClonerCreator.produceOp(handle);
        }

        private static UnaryOperator<Key> produceOp(MethodHandle handle) {
            return original -> {
                try {
                    return handle.invoke((Key)original);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new UndeclaredThrowableException(throwable);
                }
            };
        }
    }
}

