/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.client.MatchUserRule;
import org.wildfly.security.util.URIUtil;

class MatchNoUserRule
extends MatchRule {
    MatchNoUserRule(MatchRule parent) {
        super(parent.without(MatchUserRule.class));
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority, String purpose) {
        String userInfo = URIUtil.getUserFromURI(uri);
        return userInfo == null && super.matches(uri, abstractType, abstractTypeAuthority, purpose);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchNoUserRule(newParent);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return other.getMatchUser() == null && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return 3121 + this.parentHashCode();
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("no user,");
    }
}

