/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.server.IdentityLocator;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.SupportLevel;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

public class LegacyPropertiesSecurityRealm
implements SecurityRealm {
    private static final String COMMENT_PREFIX1 = "#";
    private static final String COMMENT_PREFIX2 = "!";
    private static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    private static final String REALM_COMMENT_SUFFIX = "$";
    private final boolean plainText;
    private final String groupsAttribute;
    private final AtomicReference<LoadedState> loadedState = new AtomicReference();

    private LegacyPropertiesSecurityRealm(Builder builder) throws IOException {
        this.plainText = builder.plainText;
        this.groupsAttribute = builder.groupsAttribute;
    }

    @Override
    public RealmIdentity getRealmIdentity(IdentityLocator locator) throws RealmUnavailableException {
        final LoadedState loadedState = this.loadedState.get();
        if (!locator.hasName()) {
            return RealmIdentity.NON_EXISTENT;
        }
        final AccountEntry accountEntry = loadedState.getAccounts().get(locator.getName());
        return new RealmIdentity(){

            @Override
            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return accountEntry != null ? LegacyPropertiesSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) : SupportLevel.UNSUPPORTED;
            }

            @Override
            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return accountEntry != null ? LegacyPropertiesSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName) : SupportLevel.UNSUPPORTED;
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return this.getCredential(credentialType, null);
            }

            @Override
            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                PasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                boolean clear;
                if (accountEntry == null) {
                    return null;
                }
                if (!PasswordCredential.class.isAssignableFrom(credentialType)) {
                    return null;
                }
                if (algorithmName == null) {
                    clear = LegacyPropertiesSecurityRealm.this.plainText;
                } else if ("clear".equals(algorithmName)) {
                    clear = true;
                } else if ("digest-md5".equals(algorithmName)) {
                    clear = false;
                } else {
                    return null;
                }
                if (clear) {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(accountEntry.getPasswordRepresentation().toCharArray());
                } else {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("digest-md5");
                    if (LegacyPropertiesSecurityRealm.this.plainText) {
                        DigestPasswordAlgorithmSpec algorithmParameterSpec = new DigestPasswordAlgorithmSpec(accountEntry.getName(), loadedState.getRealmName());
                        passwordSpec = new EncryptablePasswordSpec(accountEntry.getPasswordRepresentation().toCharArray(), algorithmParameterSpec);
                    } else {
                        byte[] hashed = ByteIterator.ofBytes(accountEntry.getPasswordRepresentation().getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                        passwordSpec = new DigestPasswordSpec(accountEntry.getName(), loadedState.getRealmName(), hashed);
                    }
                }
                try {
                    return (C)((Credential)credentialType.cast(new PasswordCredential(passwordFactory.generatePassword(passwordSpec))));
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                PasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                if (accountEntry == null || !(evidence instanceof PasswordGuessEvidence)) {
                    return false;
                }
                char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                if (LegacyPropertiesSecurityRealm.this.plainText) {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(accountEntry.getPasswordRepresentation().toCharArray());
                } else {
                    passwordFactory = LegacyPropertiesSecurityRealm.this.getPasswordFactory("digest-md5");
                    byte[] hashed = ByteIterator.ofBytes(accountEntry.getPasswordRepresentation().getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                    passwordSpec = new DigestPasswordSpec(accountEntry.getName(), loadedState.getRealmName(), hashed);
                }
                try {
                    Password actualPassword = passwordFactory.generatePassword(passwordSpec);
                    return passwordFactory.verify(actualPassword, guess);
                }
                catch (IllegalStateException | InvalidKeyException | InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean exists() throws RealmUnavailableException {
                return accountEntry != null;
            }

            @Override
            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                if (accountEntry == null) {
                    return AuthorizationIdentity.EMPTY;
                }
                return AuthorizationIdentity.basicIdentity(new MapAttributes(Collections.singletonMap(LegacyPropertiesSecurityRealm.this.groupsAttribute, accountEntry.getGroups())));
            }
        };
    }

    private PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return PasswordCredential.class.isAssignableFrom(credentialType) && (algorithmName == null || algorithmName.equals("clear") && this.plainText || algorithmName.equals("digest-md5")) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    public void load(InputStream passwordsStream, InputStream groupsStream) throws IOException {
        HashMap<String, AccountEntry> accounts = new HashMap<String, AccountEntry>();
        Properties groups = new Properties();
        if (groupsStream != null) {
            try (InputStreamReader is = new InputStreamReader(groupsStream, StandardCharsets.UTF_8);){
                groups.load(is);
            }
        }
        String realmName = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(passwordsStream, StandardCharsets.UTF_8));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                String trimmed = currentLine.trim();
                if (trimmed.startsWith(COMMENT_PREFIX1) && trimmed.contains(REALM_COMMENT_PREFIX)) {
                    int start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length();
                    int end = trimmed.indexOf(REALM_COMMENT_SUFFIX, start);
                    if (end <= -1) continue;
                    realmName = trimmed.substring(start, end);
                    continue;
                }
                if (trimmed.startsWith(COMMENT_PREFIX1) || trimmed.startsWith(COMMENT_PREFIX2)) continue;
                String username = null;
                StringBuilder builder = new StringBuilder();
                CodePointIterator it = CodePointIterator.ofString(trimmed);
                while (it.hasNext()) {
                    int cp = it.next();
                    if (cp == 92 && it.hasNext()) {
                        builder.appendCodePoint(it.next());
                        continue;
                    }
                    if (username == null && (cp == 61 || cp == 58)) {
                        username = builder.toString().trim();
                        builder = new StringBuilder();
                        continue;
                    }
                    builder.appendCodePoint(cp);
                }
                if (username == null) continue;
                String password = builder.toString().trim();
                accounts.put(username, new AccountEntry(username, password, groups.getProperty(username)));
            }
        }
        if (realmName == null) {
            throw ElytronMessages.log.noRealmFoundInProperties();
        }
        this.loadedState.set(new LoadedState(accounts, realmName, System.currentTimeMillis()));
    }

    public long getLoadTime() {
        return this.loadedState.get().getLoadTime();
    }

    public static Builder builder() {
        return new Builder();
    }

    private class AccountEntry {
        private final String name;
        private final String passwordRepresentation;
        private final Set<String> groups;

        private AccountEntry(String name, String passwordRepresentation, String groups) {
            this.name = name;
            this.passwordRepresentation = passwordRepresentation;
            this.groups = this.convertGroups(groups);
        }

        private Set<String> convertGroups(String groups) {
            if (groups == null) {
                return Collections.emptySet();
            }
            String[] groupArray = groups.split(",");
            HashSet<String> groupsSet = new HashSet<String>(groupArray.length);
            for (String current : groupArray) {
                String value = current.trim();
                if (value.length() <= 0) continue;
                groupsSet.add(value);
            }
            return Collections.unmodifiableSet(groupsSet);
        }

        public String getName() {
            return this.name;
        }

        public String getPasswordRepresentation() {
            return this.passwordRepresentation;
        }

        public Set<String> getGroups() {
            return this.groups;
        }
    }

    private static class LoadedState {
        private final Map<String, AccountEntry> accounts;
        private final String realmName;
        private final long loadTime;

        private LoadedState(Map<String, AccountEntry> accounts, String realmName, long loadTime) {
            this.accounts = accounts;
            this.realmName = realmName;
            this.loadTime = loadTime;
        }

        public Map<String, AccountEntry> getAccounts() {
            return this.accounts;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public long getLoadTime() {
            return this.loadTime;
        }
    }

    public static class Builder {
        private InputStream passwordsStream;
        private InputStream groupsStream;
        private boolean plainText;
        private String groupsAttribute = "groups";

        Builder() {
        }

        public Builder setPasswordsStream(InputStream passwordsStream) {
            this.passwordsStream = passwordsStream;
            return this;
        }

        public Builder setGroupsStream(InputStream groupsStream) {
            this.groupsStream = groupsStream;
            return this;
        }

        public Builder setGroupsAttribute(String groupsAttribute) {
            this.groupsAttribute = groupsAttribute;
            return this;
        }

        public Builder setPlainText(boolean plainText) {
            this.plainText = plainText;
            return this;
        }

        public LegacyPropertiesSecurityRealm build() throws IOException {
            LegacyPropertiesSecurityRealm realm = new LegacyPropertiesSecurityRealm(this);
            realm.load(this.passwordsStream, this.groupsStream);
            return realm;
        }
    }
}

