/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import javax.crypto.SecretKey;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.key.KeyUtil;

public final class SecretKeyCredential
implements AlgorithmCredential {
    private final SecretKey secretKey;

    public SecretKeyCredential(SecretKey secretKey) {
        Assert.checkNotNullParam((String)"secretKey", (Object)secretKey);
        this.secretKey = secretKey;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    @Override
    public String getAlgorithm() {
        return this.secretKey.getAlgorithm();
    }

    @Override
    public SecretKeyCredential clone() {
        SecretKey secretKey = this.secretKey;
        SecretKey clone = KeyUtil.cloneKey(SecretKey.class, secretKey);
        return clone == secretKey ? this : new SecretKeyCredential(clone);
    }
}

