/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.IdentityLocator;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class KeyStoreBackedSecurityRealm
implements SecurityRealm {
    private final Supplier<Provider[]> providers;
    private final KeyStore keyStore;

    public KeyStoreBackedSecurityRealm(KeyStore keyStore) {
        this(keyStore, Security::getProviders);
    }

    public KeyStoreBackedSecurityRealm(KeyStore keyStore, Supplier<Provider[]> providers) {
        this.keyStore = keyStore;
        this.providers = providers;
    }

    @Override
    public RealmIdentity getRealmIdentity(IdentityLocator locator) throws RealmUnavailableException {
        if (!locator.hasName()) {
            return RealmIdentity.NON_EXISTENT;
        }
        return new KeyStoreRealmIdentity(locator.getName());
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        return SupportLevel.POSSIBLY_SUPPORTED;
    }

    private KeyStore.Entry getEntry(String name) {
        try {
            return this.keyStore.getEntry(name, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            ElytronMessages.log.tracef(e, "Obtaining entry [%s] from KeyStore failed", name);
            return null;
        }
    }

    private class KeyStoreRealmIdentity
    implements RealmIdentity {
        private final String name;

        private KeyStoreRealmIdentity(String name) {
            this.name = name;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credentialType.isInstance(credential) && (algorithmName == null || credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return null;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credentialType.isInstance(credential) && (algorithmName == null || credential instanceof AlgorithmCredential && algorithmName.equals(((AlgorithmCredential)credential).getAlgorithm()))) {
                return (C)((Credential)credentialType.cast(credential));
            }
            return null;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() {
            return AuthorizationIdentity.EMPTY;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                return SupportLevel.UNSUPPORTED;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credential != null && credential.canVerify(evidenceType, algorithmName)) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            KeyStore.Entry entry = KeyStoreBackedSecurityRealm.this.getEntry(this.name);
            if (entry == null) {
                ElytronMessages.log.tracef("Evidence verification failed - alias [%s] does not exist in KeyStore", this.name);
                return false;
            }
            Credential credential = Credential.fromKeyStoreEntry(entry);
            if (credential != null && credential.canVerify(evidence) && credential.verify(KeyStoreBackedSecurityRealm.this.providers, evidence)) {
                ElytronMessages.log.tracef("Evidence verification succeed for alias [%s]", this.name);
                return true;
            }
            ElytronMessages.log.tracef("Evidence verification failed - credential of alias [%s] rejected it", this.name);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return KeyStoreBackedSecurityRealm.this.getEntry(this.name) != null;
        }
    }
}

