/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.sasl.digest.AbstractDigestFactory;
import org.wildfly.security.sasl.digest.DigestSaslServer;

public class DigestServerFactory
extends AbstractDigestFactory
implements SaslServerFactory {
    private final Supplier<Provider[]> providers;

    public DigestServerFactory() {
        this.providers = Security::getProviders;
    }

    public DigestServerFactory(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Boolean utf8;
        if (!this.matches(props) || !this.matchesMech(mechanism)) {
            return null;
        }
        String[] realms = null;
        AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
        try {
            cbh.handle(new Callback[]{availableRealmsCallback});
            realms = availableRealmsCallback.getRealmNames();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.log.mechCallbackHandlerFailedForUnknownReason(mechanism, e).toSaslException();
        }
        if (realms == null) {
            realms = new String[]{serverName};
        }
        Charset charset = (utf8 = (Boolean)props.get("com.sun.security.sasl.digest.utf8")) == null || utf8 != false ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        String qopsString = (String)props.get("javax.security.sasl.qop");
        String[] qops = qopsString == null ? null : qopsString.split(",");
        String supportedCipherOpts = (String)props.get("org.jboss.security.sasl.digest.ciphers");
        String[] cipherOpts = supportedCipherOpts == null ? null : supportedCipherOpts.split(",");
        DigestSaslServer server = new DigestSaslServer(realms, mechanism, protocol, serverName, cbh, charset, qops, cipherOpts, this.providers);
        server.init();
        return server;
    }
}

