/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.wildfly.security._private.ElytronMessages;

public final class AtomicFileOutputStream
extends OutputStream {
    private volatile State current;
    private static final AtomicReferenceFieldUpdater<AtomicFileOutputStream, State> currentUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicFileOutputStream.class, State.class, "current");
    private static final State CLOSED = new State(){

        @Override
        void write(int b) throws IOException {
            throw ElytronMessages.log.closed();
        }

        @Override
        void write(byte[] b, int off, int len) throws IOException {
            throw ElytronMessages.log.closed();
        }

        @Override
        void flush() throws IOException {
            throw ElytronMessages.log.closed();
        }

        @Override
        void close() throws IOException {
        }

        @Override
        void cancel() throws IOException {
        }
    };

    public AtomicFileOutputStream(String name) throws IOException {
        this(Paths.get(name, new String[0]));
    }

    public AtomicFileOutputStream(File file) throws IOException {
        this(file.toPath());
    }

    public AtomicFileOutputStream(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent.getNameCount() != 0 && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.current = new OpenState(Files.newOutputStream(path.resolveSibling(path.getFileName() + ".new"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), path);
    }

    @Override
    public void flush() throws IOException {
        this.current.flush();
    }

    @Override
    public void close() throws IOException {
        this.current.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.current.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.current.write(bytes, off, len);
    }

    boolean casCurrent(State expect, State update) {
        return currentUpdater.compareAndSet(this, expect, update);
    }

    public void cancel() throws IOException {
        this.current.cancel();
    }

    final class OpenState
    extends State {
        private final OutputStream delegate;
        private final Path path;

        OpenState(OutputStream delegate, Path path) {
            this.delegate = delegate;
            this.path = path;
        }

        @Override
        void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        void close() throws IOException {
            if (AtomicFileOutputStream.this.casCurrent(this, CLOSED)) {
                this.delegate.close();
                Path path = this.path;
                Path newPath = path.resolveSibling(path.getFileName() + ".new");
                try {
                    Files.move(newPath, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Throwable t) {
                    try {
                        Files.deleteIfExists(newPath);
                    }
                    catch (Throwable problem) {
                        problem.addSuppressed(t);
                        throw problem;
                    }
                    throw t;
                }
            }
        }

        @Override
        void cancel() throws IOException {
            if (AtomicFileOutputStream.this.casCurrent(this, CLOSED)) {
                this.delegate.close();
                Path newPath = this.path.resolveSibling(this.path.getFileName() + ".new");
                Files.deleteIfExists(newPath);
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract void write(int var1) throws IOException;

        abstract void write(byte[] var1, int var2, int var3) throws IOException;

        abstract void flush() throws IOException;

        abstract void close() throws IOException;

        abstract void cancel() throws IOException;
    }
}

