/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.AccessController;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ElytronXmlParser;
import org.wildfly.security.auth.client.InvalidAuthenticationConfigurationException;

class DefaultAuthenticationContextProvider {
    static final AuthenticationContext DEFAULT = AccessController.doPrivileged(() -> {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = DefaultAuthenticationContextProvider.class.getClassLoader();
        }
        try {
            return ElytronXmlParser.parseAuthenticationClientConfiguration().create();
        }
        catch (Throwable t) {
            throw new InvalidAuthenticationConfigurationException(t);
        }
    });

    DefaultAuthenticationContextProvider() {
    }
}

