/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util._private.Arrays2;

class BasicAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private static final String CHALLENGE_PREFIX = "Basic ";
    private static final int PREFIX_LENGTH = "Basic ".length();
    private final CallbackHandler callbackHandler;
    private final boolean includeCharset;
    private final String realm;

    BasicAuthenticationMechanism(CallbackHandler callbackHandler, String realm, boolean includeCharset) {
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        this.callbackHandler = callbackHandler;
        this.includeCharset = includeCharset;
        this.realm = realm;
    }

    @Override
    public String getMechanismName() {
        return "BASIC";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        List<String> authorizationValues = request.getRequestHeaderValues("Authorization");
        if (authorizationValues != null) {
            for (String current : authorizationValues) {
                if (!current.startsWith(CHALLENGE_PREFIX)) continue;
                byte[] decodedValue = ByteIterator.ofBytes(current.substring(PREFIX_LENGTH).getBytes(StandardCharsets.UTF_8)).base64Decode().drain();
                int colonPos = Arrays2.indexOf(decodedValue, 58);
                if (colonPos <= 0 || colonPos == decodedValue.length - 1) {
                    throw ElytronMessages.log.incorrectlyFormattedHeader("Authorization");
                }
                ByteBuffer usernameBytes = ByteBuffer.wrap(decodedValue, 0, colonPos);
                ByteBuffer passwordBytes = ByteBuffer.wrap(decodedValue, colonPos + 1, decodedValue.length - colonPos - 1);
                CharBuffer usernameChars = StandardCharsets.UTF_8.decode(usernameBytes);
                CharBuffer passwordChars = StandardCharsets.UTF_8.decode(passwordBytes);
                char[] password = new char[passwordChars.length()];
                passwordChars.get(password);
                try {
                    String username = usernameChars.toString();
                    if (this.authenticate(username, passwordChars.array())) {
                        SecurityIdentityCallback securityIdentityCallback = new SecurityIdentityCallback();
                        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED, securityIdentityCallback});
                        request.authenticationComplete(securityIdentityCallback.getSecurityIdentity());
                        return;
                    }
                    this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
                    request.authenticationFailed(ElytronMessages.log.authenticationFailed(username, "BASIC"), response -> this.prepareResponse(() -> this.getHostName(request), response));
                    return;
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException(e);
                }
                finally {
                    Arrays.fill(password, '\u0000');
                    if (passwordChars.hasArray()) {
                        Arrays.fill(passwordChars.array(), '\u0000');
                    }
                }
            }
        }
        request.authenticationInProgress(response -> this.prepareResponse(() -> this.getHostName(request), response));
    }

    private boolean authenticate(String username, char[] password) throws HttpAuthenticationException {
        RealmCallback realmCallback = this.realm != null ? new RealmCallback("User realm", this.realm) : null;
        NameCallback nameCallback = new NameCallback("Remote Authentication Name", username);
        nameCallback.setName(username);
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password);
        EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback(evidence);
        try {
            Callback[] callbacks = realmCallback != null ? new Callback[]{realmCallback, nameCallback, evidenceVerifyCallback} : new Callback[]{nameCallback, evidenceVerifyCallback};
            this.callbackHandler.handle(callbacks);
            boolean bl = evidenceVerifyCallback.isVerified();
            return bl;
        }
        catch (UnsupportedCallbackException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            evidence.destroy();
        }
    }

    private String getHostName(HttpServerRequest request) {
        return request.getFirstRequestHeaderValue("Host");
    }

    private void prepareResponse(Supplier<String> hostnameSupplier, HttpServerResponse response) {
        String realmName = this.realm != null ? this.realm : hostnameSupplier.get();
        StringBuilder sb = new StringBuilder(CHALLENGE_PREFIX);
        sb.append("realm").append("=\"").append(realmName).append("\"");
        if (this.includeCharset) {
            sb.append(", ").append("charset").append("=\"UTF-8\"");
        }
        response.addResponseHeader("WWW-Authenticate", sb.toString());
        response.setResponseCode(401);
    }
}

