/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import org.wildfly.security.auth.AuthenticationException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.client.PeerIdentityHandle;
import org.wildfly.security.auth.client.PeerIdentityProvider;
import org.wildfly.security.auth.principal.AnonymousPrincipal;

public final class PeerIdentityContext {
    private final PeerIdentity anonymous;
    private final ThreadLocal<PeerIdentity> currentIdentity;
    private final PeerIdentityProvider peerIdentityProvider;

    PeerIdentityContext(PeerIdentityHandle anonymousHandle, PeerIdentityProvider peerIdentityProvider) {
        this.peerIdentityProvider = peerIdentityProvider;
        this.anonymous = new PeerIdentity(this, AnonymousPrincipal.getInstance(), anonymousHandle);
        this.currentIdentity = new ThreadLocal();
    }

    public PeerIdentity getAnonymousPeerIdentity() {
        return this.anonymous;
    }

    public PeerIdentity getCurrentIdentity() {
        PeerIdentity identity = this.currentIdentity.get();
        return identity == null ? this.anonymous : identity;
    }

    public PeerIdentity authenticate(AuthenticationConfiguration authenticationConfiguration) throws AuthenticationException {
        PeerIdentityHandle handle = this.peerIdentityProvider.authenticate(authenticationConfiguration);
        return new PeerIdentity(this, authenticationConfiguration.getPrincipal(), handle);
    }

    PeerIdentity getAndSetPeerIdentity(PeerIdentity newIdentity) {
        assert (newIdentity.getContext() == this);
        try {
            PeerIdentity peerIdentity = this.currentIdentity.get();
            return peerIdentity;
        }
        finally {
            if (newIdentity == this.anonymous) {
                this.currentIdentity.remove();
            } else {
                this.currentIdentity.set(newIdentity);
            }
        }
    }

    void setPeerIdentity(PeerIdentity newIdentity) {
        assert (newIdentity.getContext() == this);
        if (newIdentity == this.anonymous) {
            this.currentIdentity.remove();
        } else {
            this.currentIdentity.set(newIdentity);
        }
    }
}

