/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.keystore.PasswordEntry;
import org.wildfly.security.x500.X500;

public interface Credential {
    default public boolean canVerify(Class<? extends Evidence> evidenceClass, String algorithmName) {
        Assert.checkNotNullParam((String)"evidenceClass", evidenceClass);
        return false;
    }

    default public boolean canVerify(Evidence evidence) {
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        return this.canVerify(evidence.getClass(), evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null);
    }

    default public boolean verify(Evidence evidence) {
        return this.verify(Security::getProviders, evidence);
    }

    default public boolean verify(Supplier<Provider[]> providerSupplier, Evidence evidence) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        return false;
    }

    public static Credential fromKeyStoreEntry(KeyStore.Entry keyStoreEntry) {
        Assert.checkNotNullParam((String)"keyStoreEntry", (Object)keyStoreEntry);
        if (keyStoreEntry instanceof PasswordEntry) {
            return new PasswordCredential(((PasswordEntry)keyStoreEntry).getPassword());
        }
        if (keyStoreEntry instanceof KeyStore.PrivateKeyEntry) {
            return new X509CertificateChainPrivateCredential(((KeyStore.PrivateKeyEntry)keyStoreEntry).getPrivateKey(), X500.asX509CertificateArray(((KeyStore.PrivateKeyEntry)keyStoreEntry).getCertificateChain()));
        }
        if (keyStoreEntry instanceof KeyStore.TrustedCertificateEntry) {
            return new X509CertificateChainPublicCredential((X509Certificate)((KeyStore.TrustedCertificateEntry)keyStoreEntry).getTrustedCertificate());
        }
        if (keyStoreEntry instanceof KeyStore.SecretKeyEntry) {
            return new SecretKeyCredential(((KeyStore.SecretKeyEntry)keyStoreEntry).getSecretKey());
        }
        return null;
    }
}

