/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public final class PasswordCredential
implements AlgorithmCredential {
    private final Password password;

    public PasswordCredential(Password password) {
        Assert.checkNotNullParam((String)"password", (Object)password);
        this.password = password;
    }

    public Password getPassword() {
        return this.password;
    }

    public <P extends Password> P getPassword(Class<P> type) {
        return (P)(type.isInstance(this.password) ? (Password)type.cast(this.password) : null);
    }

    @Override
    public String getAlgorithm() {
        return this.password.getAlgorithm();
    }

    @Override
    public boolean canVerify(Class<? extends Evidence> evidenceClass, String algorithmName) {
        return PasswordCredential.canVerifyEvidence(evidenceClass, algorithmName);
    }

    public static boolean canVerifyEvidence(Class<? extends Evidence> evidenceClass, String algorithmName) {
        Assert.checkNotNullParam((String)"evidenceClass", evidenceClass);
        return evidenceClass == PasswordGuessEvidence.class && algorithmName == null;
    }

    @Override
    public boolean verify(Supplier<Provider[]> providerSupplier, Evidence evidence) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        Assert.checkNotNullParam((String)"evidence", (Object)evidence);
        if (evidence instanceof PasswordGuessEvidence) {
            try {
                PasswordFactory factory = PasswordFactory.getInstance(this.password.getAlgorithm(), providerSupplier);
                return factory.verify(factory.translate(this.password), ((PasswordGuessEvidence)evidence).getGuess());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                // empty catch block
            }
        }
        return false;
    }
}

