/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.Provider;
import java.security.Security;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ConfiguredSSLContextSpi;
import org.wildfly.security.ssl.DelegatingSSLContext;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.ssl.SecurityDomainTrustManager;
import org.wildfly.security.ssl.ServerSSLConfigurator;
import org.wildfly.security.x500.X509CertificateEvidenceDecoder;

public final class ServerSSLContextBuilder {
    private SecurityDomain securityDomain;
    private EvidenceDecoder evidenceDecoder = X509CertificateEvidenceDecoder.getInstance();
    private CipherSuiteSelector cipherSuiteSelector = CipherSuiteSelector.openSslDefault();
    private ProtocolSelector protocolSelector = ProtocolSelector.DEFAULT_SELECTOR;
    private boolean requireClientAuth;
    private SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory;
    private Supplier<Provider[]> providerSupplier = Security::getProviders;

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setEvidenceDecoder(EvidenceDecoder evidenceDecoder) {
        Assert.checkNotNullParam((String)"evidenceDecoder", (Object)evidenceDecoder);
        this.evidenceDecoder = evidenceDecoder;
    }

    public void setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
        Assert.checkNotNullParam((String)"cipherSuiteSelector", (Object)cipherSuiteSelector);
        this.cipherSuiteSelector = cipherSuiteSelector;
    }

    public void setProtocolSelector(ProtocolSelector protocolSelector) {
        Assert.checkNotNullParam((String)"protocolSelector", (Object)protocolSelector);
        this.protocolSelector = protocolSelector;
    }

    public void setRequireClientAuth(boolean requireClientAuth) {
        this.requireClientAuth = requireClientAuth;
    }

    public void setKeyManagerSecurityFactory(SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory) {
        Assert.checkNotNullParam((String)"keyManagerSecurityFactory", keyManagerSecurityFactory);
        this.keyManagerSecurityFactory = keyManagerSecurityFactory;
    }

    public void setKeyManager(X509ExtendedKeyManager keyManager) {
        Assert.checkNotNullParam((String)"keyManager", (Object)keyManager);
        this.keyManagerSecurityFactory = new FixedSecurityFactory<X509ExtendedKeyManager>(keyManager);
    }

    public void setProviderSupplier(Supplier<Provider[]> providerSupplier) {
        Assert.checkNotNullParam((String)"providerSupplier", providerSupplier);
        this.providerSupplier = providerSupplier;
    }

    public SecurityFactory<SSLContext> build() {
        SecurityDomain securityDomain = this.securityDomain;
        CipherSuiteSelector cipherSuiteSelector = this.cipherSuiteSelector;
        ProtocolSelector protocolSelector = this.protocolSelector;
        boolean requireClientAuth = this.requireClientAuth;
        SecurityFactory<X509ExtendedKeyManager> keyManagerSecurityFactory = this.keyManagerSecurityFactory;
        EvidenceDecoder evidenceDecoder = this.evidenceDecoder;
        Supplier<Provider[]> providerSupplier = this.providerSupplier;
        return new OneTimeSecurityFactory<SSLContext>(() -> {
            SecurityFactory<SSLContext> sslContextFactory = SSLUtils.createSslContextFactory(protocolSelector, providerSupplier);
            SSLContext sslContext = sslContextFactory.create();
            X509TrustManager x509TrustManager = SSLUtils.getDefaultX509TrustManagerSecurityFactory().create();
            boolean canAuthClients = securityDomain != null;
            sslContext.init(new KeyManager[]{(KeyManager)keyManagerSecurityFactory.create()}, new TrustManager[]{canAuthClients ? new SecurityDomainTrustManager(x509TrustManager, securityDomain, evidenceDecoder) : x509TrustManager}, null);
            ServerSSLConfigurator sslConfigurator = new ServerSSLConfigurator(protocolSelector, cipherSuiteSelector, canAuthClients, canAuthClients && requireClientAuth);
            ConfiguredSSLContextSpi contextSpi = new ConfiguredSSLContextSpi(sslContext, sslConfigurator);
            return new DelegatingSSLContext(contextSpi);
        });
    }
}

