/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.SSLCallback;

public final class SSLQueryCallbackHandler
implements CallbackHandler {
    private final CallbackHandler delegate;
    private final SSLContext sslContext;
    private final SSLEngine sslEngine;
    private final SSLSocket sslSocket;
    private final AtomicBoolean once = new AtomicBoolean();

    public SSLQueryCallbackHandler(CallbackHandler delegate, SSLContext sslContext, SSLEngine sslEngine) {
        this.delegate = delegate;
        this.sslContext = sslContext;
        this.sslEngine = sslEngine;
        this.sslSocket = null;
    }

    public SSLQueryCallbackHandler(CallbackHandler delegate, SSLContext sslContext, SSLSocket sslSocket) {
        this.delegate = delegate;
        this.sslContext = sslContext;
        this.sslSocket = sslSocket;
        this.sslEngine = null;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!this.once.compareAndSet(false, true)) {
            this.delegate.handle(callbacks);
            return;
        }
        int length = callbacks.length;
        Callback[] newCallbacks = new Callback[length + 1];
        newCallbacks[0] = this.sslEngine != null ? new SSLCallback(this.sslContext, this.sslEngine) : new SSLCallback(this.sslContext, this.sslSocket);
        System.arraycopy(callbacks, 0, newCallbacks, 1, length);
        try {
            this.delegate.handle(newCallbacks);
        }
        catch (UnsupportedCallbackException e) {
            if (e.getCallback() instanceof SSLCallback) {
                this.delegate.handle(callbacks);
                return;
            }
            throw e;
        }
    }
}

