/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.key;

import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Objects;
import org.wildfly.security.key.RawKey;

class RawRSAPrivateKey
extends RawKey
implements RSAPrivateKey,
PrivateKey {
    private static final long serialVersionUID = -184627557213615873L;
    private final BigInteger privateExponent;
    private final BigInteger modulus;

    RawRSAPrivateKey(RSAPrivateKey original) {
        super(original);
        this.privateExponent = original.getPrivateExponent();
        this.modulus = original.getModulus();
    }

    RawRSAPrivateKey(Key original) {
        this((RSAPrivateKey)original);
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    boolean isEqual(Key key) {
        return key instanceof RSAPrivateKey && this.isEqual((RSAPrivateKey)key);
    }

    boolean isEqual(RSAPrivateKey key) {
        return super.isEqual(key) && Objects.equals(this.privateExponent, key.getPrivateExponent()) && Objects.equals(this.modulus, key.getModulus());
    }
}

